/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.AbstractSettings;
import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.CllSettings;
import com.microsoft.cll.android.HostSettings;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.PartA;
import com.microsoft.cll.android.ScheduledWorker;
import com.microsoft.cll.android.SettingsStore;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class SettingsSync
extends ScheduledWorker {
    private final ClientTelemetry clientTelemetry;
    private final ILogger logger;
    private final String TAG = "AndroidCll-SettingsSync";
    private final List<AbstractSettings> settingsList;

    public SettingsSync(ClientTelemetry clientTelemetry, ILogger logger, String iKey, PartA partA) {
        super(SettingsStore.getCllSettingsAsLong(SettingsStore.Settings.SYNCREFRESHINTERVAL));
        this.clientTelemetry = clientTelemetry;
        this.logger = logger;
        this.settingsList = new ArrayList<AbstractSettings>();
        this.settingsList.add(new CllSettings(clientTelemetry, logger, this, partA));
        if (!iKey.equals("")) {
            this.settingsList.add(new HostSettings(clientTelemetry, logger, iKey, partA));
        }
    }

    @Override
    public void run() {
        this.logger.info("AndroidCll-SettingsSync", "Cloud sync!");
        this.GetCloudSettings();
    }

    private void GetCloudSettings() {
        for (AbstractSettings abstractSettings : this.settingsList) {
            JSONObject json = abstractSettings.getSettings();
            if (json == null) {
                this.logger.error("AndroidCll-SettingsSync", "Could not get or parse settings");
                continue;
            }
            abstractSettings.ParseSettings(json);
        }
    }
}

