/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.EventEnums;
import com.microsoft.telemetry.Base;
import java.util.EnumSet;
import java.util.HashMap;

public class SettingsStore {
    private static HashMap<String, String> hostEventSettings = new HashMap();
    protected static HashMap<Settings, Object> cllSettings = new HashMap();
    private static UpdateListener updateListener;

    protected static int getCllSettingsAsInt(Settings setting) {
        return Integer.parseInt(cllSettings.get((Object)setting).toString());
    }

    protected static long getCllSettingsAsLong(Settings setting) {
        return Long.parseLong(cllSettings.get((Object)setting).toString());
    }

    protected static boolean getCllSettingsAsBoolean(Settings setting) {
        return Boolean.parseBoolean(cllSettings.get((Object)setting).toString());
    }

    protected static String getCllSettingsAsString(Settings setting) {
        return cllSettings.get((Object)setting).toString();
    }

    public static void setUpdateListener(UpdateListener updateListener) {
        SettingsStore.updateListener = updateListener;
    }

    public static void updateHostSetting(String settingName, String settingValue) {
        if (hostEventSettings.get(settingName) == null || !hostEventSettings.get(settingName).equals(settingValue)) {
            hostEventSettings.put(settingName, settingValue);
            if (updateListener != null) {
                updateListener.OnHostSettingUpdate(settingName, settingValue);
            }
        }
    }

    public static void updateCllSetting(Settings settingName, String settingValue) {
        if (cllSettings.get((Object)settingName) == null || !cllSettings.get((Object)settingName).equals(settingValue)) {
            cllSettings.put(settingName, settingValue);
            if (updateListener != null) {
                updateListener.OnCllSettingUpdate(settingName.toString(), settingValue);
            }
        }
    }

    public static EventEnums.Latency getLatencyForEvent(Base base, EventEnums.Latency passedInValue) {
        String settingName = "LATENCY";
        String valueString = SettingsStore.getSettingFromCloud(base, settingName);
        if (valueString != null) {
            return EventEnums.Latency.FromString(valueString);
        }
        if (passedInValue != null && passedInValue != EventEnums.Latency.LatencyUnspecified) {
            return passedInValue;
        }
        valueString = SettingsStore.getSettingFromSchema(base, settingName);
        if (valueString != null) {
            return EventEnums.Latency.FromString(valueString.toUpperCase());
        }
        valueString = SettingsStore.getSettingFromCloudDefaults(settingName);
        if (valueString != null) {
            return EventEnums.Latency.FromString(valueString);
        }
        return EventEnums.Latency.LatencyNormal;
    }

    public static EventEnums.Persistence getPersistenceForEvent(Base base, EventEnums.Persistence passedInValue) {
        String settingName = "PERSISTENCE";
        String valueString = SettingsStore.getSettingFromCloud(base, settingName);
        if (valueString != null) {
            return EventEnums.Persistence.FromString(valueString);
        }
        if (passedInValue != null && passedInValue != EventEnums.Persistence.PersistenceUnspecified) {
            return passedInValue;
        }
        valueString = SettingsStore.getSettingFromSchema(base, settingName);
        if (valueString != null) {
            return EventEnums.Persistence.FromString(valueString.toUpperCase());
        }
        valueString = SettingsStore.getSettingFromCloudDefaults(settingName);
        if (valueString != null) {
            return EventEnums.Persistence.FromString(valueString);
        }
        return EventEnums.Persistence.PersistenceNormal;
    }

    public static EnumSet<EventEnums.Sensitivity> getSensitivityForEvent(Base base, EnumSet<EventEnums.Sensitivity> passedInValue) {
        String settingName = "SENSITIVITY";
        String valueString = SettingsStore.getSettingFromCloud(base, settingName);
        if (valueString != null) {
            return EventEnums.Sensitivity.FromString(valueString);
        }
        if (passedInValue != null && !passedInValue.contains((Object)EventEnums.Sensitivity.SensitivityUnspecified)) {
            return passedInValue;
        }
        valueString = SettingsStore.getSettingFromSchema(base, settingName);
        if (valueString != null) {
            return EventEnums.Sensitivity.FromString(valueString.toUpperCase());
        }
        valueString = SettingsStore.getSettingFromCloudDefaults(settingName);
        if (valueString != null) {
            return EventEnums.Sensitivity.FromString(valueString);
        }
        return EnumSet.of(EventEnums.Sensitivity.SensitivityNone);
    }

    public static double getSampleRateForEvent(Base base, double passedInValue) {
        String settingName = "SAMPLERATE";
        String valueString = SettingsStore.getSettingFromCloud(base, settingName);
        if (valueString != null) {
            return EventEnums.SampleRateFromString(valueString);
        }
        if (passedInValue >= -1.0E-5) {
            return passedInValue;
        }
        valueString = SettingsStore.getSettingFromSchema(base, settingName);
        if (valueString != null) {
            return EventEnums.SampleRateFromString(valueString);
        }
        valueString = SettingsStore.getSettingFromCloudDefaults(settingName);
        if (valueString != null) {
            return EventEnums.SampleRateFromString(valueString);
        }
        return 100.0;
    }

    private static String getSettingFromCloud(Base base, String settingName) {
        String eventName;
        String namespace;
        String qualifiedEventName = base.QualifiedName.toUpperCase();
        if (qualifiedEventName.lastIndexOf(".") == -1) {
            namespace = "";
            eventName = qualifiedEventName;
        } else {
            namespace = qualifiedEventName.substring(0, qualifiedEventName.lastIndexOf("."));
            eventName = qualifiedEventName.substring(qualifiedEventName.lastIndexOf(".") + 1);
        }
        if (hostEventSettings.containsKey(namespace + ":" + eventName + "::" + settingName)) {
            return hostEventSettings.get(namespace + ":" + eventName + "::" + settingName);
        }
        if (hostEventSettings.containsKey(":" + eventName + "::" + settingName)) {
            return hostEventSettings.get(":" + eventName + "::" + settingName);
        }
        if (hostEventSettings.containsKey(namespace + ":::" + settingName)) {
            return hostEventSettings.get(namespace + ":::" + settingName);
        }
        if (hostEventSettings.containsKey(":::" + settingName)) {
            return hostEventSettings.get(":::" + settingName);
        }
        return null;
    }

    private static String getSettingFromSchema(Base base, String settingName) {
        return base.Attributes.get(settingName);
    }

    private static String getSettingFromCloudDefaults(String settingName) {
        Object settingObject = cllSettings.get(settingName);
        if (settingObject != null) {
            return settingObject.toString();
        }
        return null;
    }

    static {
        cllSettings.put(Settings.SYNCREFRESHINTERVAL, 1800);
        cllSettings.put(Settings.QUEUEDRAININTERVAL, 120);
        cllSettings.put(Settings.SNAPSHOTSCHEDULEINTERVAL, 900);
        cllSettings.put(Settings.MAXEVENTSIZEINBYTES, 65536);
        cllSettings.put(Settings.MAXEVENTSPERPOST, 500);
        cllSettings.put(Settings.MAXFILESSPACE, 0xA00000);
        cllSettings.put(Settings.UPLOADENABLED, true);
        cllSettings.put(Settings.HTTPTIMEOUTINTERVAL, 60000);
        cllSettings.put(Settings.THREADSTOUSEWITHEXECUTOR, 3);
        cllSettings.put(Settings.MAXCRITICALCANADDATTEMPTS, 5);
        cllSettings.put(Settings.MAXRETRYPERIOD, 180);
        cllSettings.put(Settings.BASERETRYPERIOD, 2);
        cllSettings.put(Settings.CONSTANTFORRETRYPERIOD, 5);
        cllSettings.put(Settings.NORMALEVENTMEMORYQUEUESIZE, 50);
        cllSettings.put(Settings.CLLSETTINGSURL, "https://settings.data.microsoft.com/settings/v2.0/androidLL/app");
        cllSettings.put(Settings.HOSTSETTINGSETAG, "");
        cllSettings.put(Settings.CLLSETTINGSETAG, "");
        cllSettings.put(Settings.VORTEXPRODURL, "https://vortex.data.microsoft.com/collect/v1");
        cllSettings.put(Settings.MAXREALTIMETHREADS, 200);
    }

    public static interface UpdateListener {
        public void OnHostSettingUpdate(String var1, String var2);

        public void OnCllSettingUpdate(String var1, String var2);
    }

    public static enum Settings {
        SYNCREFRESHINTERVAL,
        QUEUEDRAININTERVAL,
        SNAPSHOTSCHEDULEINTERVAL,
        MAXEVENTSIZEINBYTES,
        MAXEVENTSPERPOST,
        SAMPLERATE,
        MAXFILESSPACE,
        UPLOADENABLED,
        PERSISTENCE,
        LATENCY,
        HTTPTIMEOUTINTERVAL,
        THREADSTOUSEWITHEXECUTOR,
        MAXCRITICALCANADDATTEMPTS,
        MAXRETRYPERIOD,
        BASERETRYPERIOD,
        CONSTANTFORRETRYPERIOD,
        NORMALEVENTMEMORYQUEUESIZE,
        CLLSETTINGSURL,
        HOSTSETTINGSETAG,
        CLLSETTINGSETAG,
        VORTEXPRODURL,
        MAXREALTIMETHREADS;

    }
}

