/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class ScheduledWorker
implements Runnable {
    protected ScheduledFuture nextExecution;
    protected ScheduledExecutorService executor;
    protected long interval;
    protected boolean isPaused;

    public ScheduledWorker(long interval) {
        this.interval = interval;
        this.isPaused = false;
    }

    @Override
    public abstract void run();

    protected void start(ScheduledExecutorService executor) {
        this.setupExecutor(executor);
    }

    protected void stop() {
        this.nextExecution.cancel(true);
    }

    protected void pause() {
        this.nextExecution.cancel(false);
        this.isPaused = true;
    }

    protected void resume(ScheduledExecutorService executor) {
        this.setupExecutor(executor);
        this.isPaused = false;
    }

    private void setupExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        this.nextExecution = executor.scheduleAtFixedRate(this, 0L, this.interval, TimeUnit.SECONDS);
    }
}

