/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.EventSendResult;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.TicketHeaders;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class EventSender {
    private final String NO_HTTPS_CONN = "URL didn't return HttpsUrlConnection instance.";
    private final String TAG = "AndroidCll-EventSender";
    private final URL endpoint;
    private final ClientTelemetry clientTelemetry;
    private final ILogger logger;

    public EventSender(URL endpoint, ClientTelemetry clientTelemetry, ILogger logger) {
        this.endpoint = endpoint;
        this.clientTelemetry = clientTelemetry;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSendResult sendEvent(byte[] body, boolean compressed, TicketHeaders ticketHeaders) throws IOException {
        EventSendResult sendResult = new EventSendResult();
        int responseCode = 500;
        int retryAfterSeconds = 0;
        InputStream inputStream = null;
        InputStream errorStream = null;
        this.clientTelemetry.IncrementVortexHttpAttempts();
        HttpURLConnection connection = this.openConnection(body.length, compressed, ticketHeaders);
        try {
            connection.connect();
        }
        catch (IOException e) {
            this.logger.error("AndroidCll-EventSender", "Error connecting.");
            throw e;
        }
        try {
            OutputStream stream = connection.getOutputStream();
            stream.write(body);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            this.logger.error("AndroidCll-EventSender", "Error writing data");
            throw e;
        }
        long start = this.getTime();
        try {
            block20: {
                try {
                    responseCode = connection.getResponseCode();
                    if (responseCode != 429 && responseCode != 503) break block20;
                    String retryAfterValueString = connection.getHeaderField("Retry-After");
                    if (retryAfterValueString != null) {
                        try {
                            retryAfterSeconds = Integer.parseInt(retryAfterValueString);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (retryAfterSeconds > 86400 || retryAfterSeconds < 0) {
                        retryAfterSeconds = 0;
                    }
                }
                catch (IOException retryAfterValueString) {
                    // empty catch block
                }
            }
            try {
                inputStream = connection.getInputStream();
                if (inputStream != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    this.processResponseBodyConditionally(reader, responseCode == 200);
                }
            }
            catch (IOException e2) {
                errorStream = connection.getErrorStream();
                if (errorStream != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));
                    this.processResponseBodyConditionally(reader, responseCode == 400);
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (errorStream != null) {
                errorStream.close();
            }
            if (responseCode >= 500 && responseCode < 600) {
                this.logger.error("AndroidCll-EventSender", "Bad Response Code");
                this.clientTelemetry.IncrementVortexHttpFailures(connection.getResponseCode());
            }
            long diff = this.getTime() - start;
            this.clientTelemetry.SetAvgVortexLatencyMs((int)diff);
            this.clientTelemetry.SetMaxVortexLatencyMs((int)diff);
        }
        sendResult.responseCode = responseCode;
        sendResult.retryAfterSeconds = retryAfterSeconds;
        return sendResult;
    }

    protected HttpURLConnection openConnection(int length, boolean compressed, TicketHeaders ticketHeaders) throws IOException {
        String ticketString = "";
        if (ticketHeaders != null && !ticketHeaders.xtokens.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, String> entry : ticketHeaders.xtokens.entrySet()) {
                if (!first) {
                    ticketString = ticketString + ";";
                }
                ticketString = ticketString + "\"" + entry.getKey() + "\"=\"" + entry.getValue() + "\"";
                first = false;
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        URLConnection connection = this.endpoint.openConnection();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpsConnection = (HttpURLConnection)connection;
            httpsConnection.setConnectTimeout(SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.HTTPTIMEOUTINTERVAL));
            httpsConnection.setReadTimeout(SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.HTTPTIMEOUTINTERVAL));
            httpsConnection.setInstanceFollowRedirects(false);
            httpsConnection.setUseCaches(false);
            httpsConnection.setDoOutput(true);
            httpsConnection.setRequestMethod("POST");
            httpsConnection.setRequestProperty("Content-Type", "application/x-json-stream; charset=utf-8");
            httpsConnection.setRequestProperty("X-UploadTime", dateFormat.format(new Date()).toString());
            httpsConnection.setRequestProperty("Content-Length", Integer.toString(length));
            if (compressed) {
                httpsConnection.setRequestProperty("Accept", "application/json");
                httpsConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
                httpsConnection.setRequestProperty("Content-Encoding", "deflate");
            }
            if (ticketString != "") {
                httpsConnection.setRequestProperty("X-Tickets", ticketString);
                if (ticketHeaders.authXToken != null && !ticketHeaders.authXToken.isEmpty()) {
                    httpsConnection.setRequestProperty("X-AuthXToken", ticketHeaders.authXToken);
                }
                if (ticketHeaders.msaDeviceTicket != null && !ticketHeaders.msaDeviceTicket.isEmpty()) {
                    httpsConnection.setRequestProperty("X-AuthMsaDeviceTicket", ticketHeaders.msaDeviceTicket);
                }
            }
            return httpsConnection;
        }
        this.clientTelemetry.IncrementVortexHttpFailures(-1);
        throw new IOException("URL didn't return HttpsUrlConnection instance.");
    }

    protected String processResponseBody(BufferedReader reader) {
        return this.processResponseBodyConditionally(reader, true);
    }

    protected String processResponseBodyConditionally(BufferedReader reader, boolean parseJson) {
        StringBuilder responseBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                responseBuilder.append(line);
            }
        }
        catch (IOException e) {
            this.logger.error("AndroidCll-EventSender", "Couldn't read response body");
        }
        if (parseJson) {
            try {
                JSONObject jsonObject = new JSONObject(responseBuilder.toString());
                int rejectCount = jsonObject.getInt("rej");
                this.clientTelemetry.IncrementRejectDropCount(rejectCount);
            }
            catch (JSONException e) {
                this.logger.info("AndroidCll-EventSender", e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.info("AndroidCll-EventSender", e.getMessage());
            }
        }
        this.logger.info("AndroidCll-EventSender", responseBuilder.toString());
        return responseBuilder.toString();
    }

    private long getTime() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US).getTimeInMillis();
    }
}

