/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.EventBatcher;
import com.microsoft.cll.android.EventCompressor;
import com.microsoft.cll.android.EventHandler;
import com.microsoft.cll.android.EventSendResult;
import com.microsoft.cll.android.EventSender;
import com.microsoft.cll.android.ICllEvents;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.IStorage;
import com.microsoft.cll.android.ITicketCallback;
import com.microsoft.cll.android.SerializedEvent;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.TicketHeaders;
import com.microsoft.cll.android.TicketManager;
import com.microsoft.cll.android.Tuple;
import com.microsoft.cll.android.Verbosity;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class EventQueueWriter
implements Runnable {
    protected static AtomicBoolean running = new AtomicBoolean(false);
    protected static ScheduledFuture future;
    private static int backoffSeconds;
    private static int retryAfterBackoffSeconds;
    private static AtomicInteger s_threadCount;
    private final String TAG = "AndroidCll-EventQueueWriter";
    private final List<IStorage> storages;
    private final List<String> ids;
    private final List<ICllEvents> cllEvents;
    private final EventBatcher batcher;
    private final SerializedEvent event;
    private final ILogger logger;
    private final ITicketCallback ticketCallback;
    private final ClientTelemetry clientTelemetry;
    private final ScheduledExecutorService executorService;
    private final TicketManager ticketManager;
    private EventSender sender;
    private List<IStorage> removedStorages;
    private EventCompressor compressor;
    private EventHandler handler;
    private URL endpoint;
    private final Random random = new Random();

    public EventQueueWriter(URL endpoint, List<IStorage> storages, ClientTelemetry clientTelemetry, List<ICllEvents> cllEvents, ILogger logger, ScheduledExecutorService executorService, ITicketCallback ticketCallback) {
        this.cllEvents = cllEvents;
        this.storages = storages;
        this.logger = logger;
        this.ticketCallback = ticketCallback;
        this.batcher = new EventBatcher();
        this.sender = new EventSender(endpoint, clientTelemetry, logger);
        this.compressor = new EventCompressor(logger);
        this.event = null;
        this.ids = null;
        this.executorService = executorService;
        this.clientTelemetry = clientTelemetry;
        this.endpoint = endpoint;
        this.removedStorages = new ArrayList<IStorage>();
        this.ticketManager = new TicketManager(ticketCallback, logger);
    }

    public EventQueueWriter(URL endpoint, SerializedEvent event, List<String> ids, ClientTelemetry clientTelemetry, List<ICllEvents> cllEvents, ILogger logger, ScheduledExecutorService executorService, EventHandler handler, ITicketCallback ticketCallback) {
        this.cllEvents = cllEvents;
        this.event = event;
        this.ids = ids;
        this.logger = logger;
        this.ticketCallback = ticketCallback;
        this.sender = new EventSender(endpoint, clientTelemetry, logger);
        this.batcher = null;
        this.storages = null;
        this.executorService = executorService;
        this.clientTelemetry = clientTelemetry;
        this.handler = handler;
        this.endpoint = endpoint;
        this.ticketManager = new TicketManager(ticketCallback, logger);
        clientTelemetry.IncrementEventsQueuedForUpload();
    }

    void setSender(EventSender sender) {
        this.sender = sender;
    }

    @Override
    public void run() {
        try {
            s_threadCount.getAndAdd(1);
            this.logger.info("AndroidCll-EventQueueWriter", "Starting upload");
            if (this.storages == null) {
                this.sendRealTimeEvent(this.event);
                return;
            }
            if (!running.compareAndSet(false, true)) {
                this.logger.info("AndroidCll-EventQueueWriter", "Skipping send, event sending is already in progress on different thread.");
                return;
            }
            this.send();
            running.set(false);
        }
        finally {
            s_threadCount.getAndAdd(-1);
        }
    }

    protected void sendRealTimeEvent(SerializedEvent singleEvent) {
        String eventString = singleEvent.getSerializedData();
        if (eventString.length() > SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSIZEINBYTES)) {
            return;
        }
        boolean sendCompleted = false;
        try {
            this.ticketManager.clean();
            this.ticketManager.addTickets(this.ids);
            TicketHeaders ticketHeaders = this.ticketManager.getHeaders(false);
            byte[] eventData = this.getEventData(eventString);
            int sendErrorCode = this.sendRequest(eventData, false, ticketHeaders);
            if (sendErrorCode == 401) {
                ticketHeaders = this.ticketManager.getHeaders(true);
                sendErrorCode = this.sendRequest(eventData, false, ticketHeaders);
            }
            if (sendErrorCode == 200 || sendErrorCode == 400) {
                sendCompleted = true;
            }
        }
        catch (IOException e) {
            this.logger.error("AndroidCll-EventQueueWriter", "Cannot send event");
        }
        if (sendCompleted) {
            this.cancelBackoff();
            for (ICllEvents event : this.cllEvents) {
                event.sendComplete();
            }
        } else {
            this.handler.addToStorage(singleEvent, this.ids);
        }
    }

    protected void send() {
        SendResult sendResult = this.sendInternal();
        if (sendResult == SendResult.SUCCESS) {
            this.cancelBackoff();
        } else {
            int interval = this.generateBackoffInterval();
            this.storages.removeAll(this.removedStorages);
            EventQueueWriter eventQueueWriter = new EventQueueWriter(this.endpoint, this.storages, this.clientTelemetry, this.cllEvents, this.logger, this.executorService, this.ticketCallback);
            eventQueueWriter.setSender(this.sender);
            future = this.executorService.schedule(eventQueueWriter, (long)interval, TimeUnit.SECONDS);
        }
    }

    private SendResult sendInternal() {
        for (IStorage storage : this.storages) {
            if (this.executorService.isShutdown()) {
                return SendResult.SUCCESS;
            }
            this.ticketManager.clean();
            for (Tuple<String, List<String>> event : storage.drain()) {
                SendResult sendResult;
                this.ticketManager.addTickets((List)event.b);
                this.clientTelemetry.IncrementEventsQueuedForUpload();
                if (((String)event.a).length() > SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSIZEINBYTES)) {
                    this.logger.warn("AndroidCll-EventQueueWriter", "Dropping event because it is too large.");
                    for (ICllEvents cllEvent : this.cllEvents) {
                        cllEvent.eventDropped((String)event.a);
                    }
                    continue;
                }
                if (this.batcher.tryAddingEventToBatch((String)event.a)) continue;
                this.logger.info("AndroidCll-EventQueueWriter", "Got a full batch, preparing to send");
                String batchedEvents = this.batcher.getBatchedEvents();
                if (!this.batcher.tryAddingEventToBatch((String)event.a)) {
                    this.logger.error("AndroidCll-EventQueueWriter", "Could not add events to an empty batch");
                }
                if ((sendResult = this.sendBatch(batchedEvents, storage)) != SendResult.ERROR) continue;
                storage.close();
                return sendResult;
            }
            this.logger.info("AndroidCll-EventQueueWriter", "Preparing to send");
            String batchedEvents = this.batcher.getBatchedEvents();
            SendResult sendResult = this.sendBatch(batchedEvents, storage);
            storage.close();
            if (sendResult == SendResult.ERROR) {
                return sendResult;
            }
            storage.discard();
        }
        this.logger.info("AndroidCll-EventQueueWriter", "Sent " + this.clientTelemetry.snapshot.getEventsQueued() + " events.");
        for (ICllEvents event : this.cllEvents) {
            event.sendComplete();
        }
        return SendResult.SUCCESS;
    }

    private void cancelBackoff() {
        future = null;
        backoffSeconds = 0;
    }

    private SendResult sendBatch(String batchedEvents, IStorage storage) {
        this.logger.info("AndroidCll-EventQueueWriter", "Sending Batch of events");
        if (batchedEvents.equals("")) {
            this.removedStorages.add(storage);
            return SendResult.SUCCESS;
        }
        this.logger.info("AndroidCll-EventQueueWriter", "Compressing events");
        boolean isCompressed = true;
        byte[] eventsData = this.compressor.compress(batchedEvents);
        if (eventsData == null) {
            eventsData = this.getEventData(batchedEvents);
            isCompressed = false;
        }
        TicketHeaders ticketHeaders = this.ticketManager.getHeaders(false);
        boolean sendCompleted = false;
        try {
            int sendErrorCode = this.sendRequest(eventsData, isCompressed, ticketHeaders);
            if (sendErrorCode == 401) {
                this.logger.info("AndroidCll-EventQueueWriter", "We got a 401 while sending the events, refreshing the tokens and trying again");
                ticketHeaders = this.ticketManager.getHeaders(true);
                sendErrorCode = this.sendRequest(eventsData, isCompressed, ticketHeaders);
                if (sendErrorCode == 401) {
                    this.logger.info("AndroidCll-EventQueueWriter", "After refreshing the tokens we still got a 401. Most likely we couldn't get new tokens so we will keep these events on disk and try to get new tokens later");
                }
            }
            if (sendErrorCode == 200 || sendErrorCode == 400) {
                sendCompleted = true;
            }
        }
        catch (IOException e) {
            this.logger.error("AndroidCll-EventQueueWriter", "Cannot send event: " + e.getMessage());
        }
        if (sendCompleted) {
            return SendResult.SUCCESS;
        }
        return SendResult.ERROR;
    }

    private int sendRequest(byte[] body, boolean isCompressed, TicketHeaders ticketHeaders) throws IOException {
        if (!this.preValidateTickets(ticketHeaders)) {
            return 401;
        }
        EventSendResult sendResult = this.sender.sendEvent(body, isCompressed, ticketHeaders);
        if (sendResult.retryAfterSeconds > 0) {
            retryAfterBackoffSeconds = sendResult.retryAfterSeconds;
        }
        return sendResult.responseCode;
    }

    private boolean preValidateTickets(TicketHeaders ticketHeaders) {
        boolean msaUserTicketFound = false;
        boolean msaDeviceTicketFound = false;
        boolean xauthUserTicketFound = false;
        boolean xauthDeviceTicketFound = false;
        if (ticketHeaders != null && ticketHeaders.xtokens != null && !ticketHeaders.xtokens.isEmpty()) {
            for (Map.Entry<String, String> ticket : ticketHeaders.xtokens.entrySet()) {
                String ticketValue = ticket.getValue();
                if (ticketValue == null || ticketValue.length() <= 3) {
                    return false;
                }
                if (ticketValue.startsWith("x:")) {
                    xauthUserTicketFound = true;
                }
                if (ticketValue.startsWith("p:")) {
                    msaUserTicketFound = true;
                }
                if (!ticketValue.startsWith("rp:")) continue;
                msaUserTicketFound = true;
                msaDeviceTicketFound = true;
            }
            if (ticketHeaders.authXToken != null && !ticketHeaders.authXToken.isEmpty()) {
                xauthDeviceTicketFound = true;
            }
            if (ticketHeaders.msaDeviceTicket != null && !ticketHeaders.msaDeviceTicket.isEmpty()) {
                msaDeviceTicketFound = true;
            }
        }
        if (msaUserTicketFound && !msaDeviceTicketFound) {
            return false;
        }
        return !xauthUserTicketFound || xauthDeviceTicketFound;
    }

    int generateBackoffInterval() {
        int interval = 0;
        if (retryAfterBackoffSeconds > 0) {
            this.logger.info("AndroidCll-EventQueueWriter", "Using backoff interval from Retry-After header.");
            interval = retryAfterBackoffSeconds;
            retryAfterBackoffSeconds = 0;
        } else {
            int startInterval = SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.CONSTANTFORRETRYPERIOD);
            int maxInterval = SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXRETRYPERIOD);
            int exponentBase = SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.BASERETRYPERIOD);
            if (backoffSeconds == 0) {
                backoffSeconds = Math.max(0, startInterval);
            }
            if (this.logger.getVerbosity() == Verbosity.INFO) {
                this.logger.info("AndroidCll-EventQueueWriter", "Generating new backoff interval using \"Random.nextInt(" + (backoffSeconds + 1) + ") seconds\" formula.");
            }
            interval = this.random.nextInt(backoffSeconds + 1);
            backoffSeconds = Math.min(backoffSeconds * exponentBase, maxInterval);
            if (this.logger.getVerbosity() == Verbosity.INFO) {
                this.logger.info("AndroidCll-EventQueueWriter", "The generated backoff interval is " + interval + ".");
            }
        }
        return interval;
    }

    private byte[] getEventData(String body) {
        return body.getBytes(Charset.forName("UTF-8"));
    }

    public static int getRunningThreadCount() {
        return s_threadCount.get();
    }

    static {
        backoffSeconds = 0;
        retryAfterBackoffSeconds = 0;
        s_threadCount = new AtomicInteger(0);
    }

    static enum SendResult {
        SUCCESS,
        ERROR;

    }
}

