/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.SettingsStore;
import java.util.Arrays;
import java.util.zip.Deflater;

public class EventCompressor {
    private final String TAG = "AndroidCll-EventCompressor";
    private final ILogger logger;

    public EventCompressor(ILogger logger) {
        this.logger = logger;
    }

    public byte[] compress(String events) {
        try {
            byte[] input = events.getBytes("UTF-8");
            byte[] output = new byte[SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSIZEINBYTES)];
            Deflater compressor = new Deflater(-1, true);
            compressor.setInput(input);
            compressor.finish();
            int compressedDataLength = compressor.deflate(output);
            compressor.end();
            if (compressedDataLength >= SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSIZEINBYTES)) {
                this.logger.error("AndroidCll-EventCompressor", "Compression resulted in a string of at least the max event buffer size of Vortex. Most likely this means we lost part of the string.");
                return null;
            }
            return Arrays.copyOfRange(output, 0, compressedDataLength);
        }
        catch (Exception e) {
            this.logger.error("AndroidCll-EventCompressor", "Could not compress events");
            return null;
        }
    }
}

