/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.SettingsStore;

public class EventBatcher {
    private StringBuilder eventString;
    private int numberOfEvents;
    private final String newLine = "\r\n";
    private int size;

    public EventBatcher(int size) {
        this.size = size;
        this.eventString = new StringBuilder(size);
        this.numberOfEvents = 0;
    }

    public EventBatcher() {
        this.size = SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSIZEINBYTES);
        this.eventString = new StringBuilder(this.size);
        this.numberOfEvents = 0;
    }

    protected boolean canAddToBatch(String serializedEvent) {
        return this.eventString.length() + "\r\n".length() + serializedEvent.length() <= this.size && this.numberOfEvents < SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.MAXEVENTSPERPOST);
    }

    public boolean tryAddingEventToBatch(String serializedEvent) {
        if (!this.canAddToBatch(serializedEvent)) {
            return false;
        }
        this.eventString.append(serializedEvent).append("\r\n");
        ++this.numberOfEvents;
        return true;
    }

    public String getBatchedEvents() {
        String batchedEvents = this.eventString.toString();
        this.eventString.setLength(0);
        this.numberOfEvents = 0;
        return batchedEvents;
    }
}

