/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import java.security.SecureRandom;

public class CorrelationVector {
    private static final String s_base64CharSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int c_maxCVLength_v1 = 64;
    private static final int c_baseCVLength_v1 = 16;
    private static final int c_maxCVLength_v2 = 128;
    private static final int c_baseCVLength_v2 = 22;
    private static final String s_validPattern_v1 = "^[A-Za-z0-9+/]{16}(.[0-9]+)*$";
    private static final String s_validPattern_v2 = "^[A-Za-z0-9+/]{22}(.[0-9]+)*$";
    private static final SecureRandom m_random = new SecureRandom();
    private boolean m_isInitialized;
    private long m_currentVector;
    private String m_baseVector;
    private int m_maxLength;

    public CorrelationVector() {
        this.UnInitialize();
    }

    public synchronized boolean Initialize(int version) {
        if (version != 1 && version != 2) {
            return false;
        }
        this.m_maxLength = version == 1 ? 64 : 128;
        int baseLength = version == 1 ? 16 : 22;
        this.m_currentVector = 0L;
        this.m_baseVector = this.InitializeInternal(baseLength);
        this.m_isInitialized = true;
        return true;
    }

    private String InitializeInternal(int baseLength) {
        String result = "";
        for (int i = 0; i < baseLength; ++i) {
            int randomNumber = m_random.nextInt(64);
            result = result + s_base64CharSet.charAt(randomNumber);
        }
        return result;
    }

    public synchronized void UnInitialize() {
        this.m_currentVector = 0L;
        this.m_baseVector = "";
        this.m_isInitialized = false;
    }

    public boolean IsInitialized() {
        return this.m_isInitialized;
    }

    public synchronized String GetValue() {
        return this.GetValueInternal();
    }

    private String GetValueInternal() {
        String value = "";
        if (this.m_isInitialized) {
            value = this.m_baseVector + "." + this.m_currentVector;
        }
        return value;
    }

    public synchronized boolean Extend() {
        boolean result = false;
        if (this.CanExtendInternal()) {
            this.m_baseVector = this.GetValueInternal();
            this.m_currentVector = 0L;
            result = true;
        }
        return result;
    }

    public synchronized boolean Increment() {
        boolean result = false;
        if (this.CanIncrementInternal()) {
            ++this.m_currentVector;
            result = true;
        }
        return result;
    }

    public synchronized boolean CanExtend() {
        return this.CanExtendInternal();
    }

    public synchronized boolean CanIncrement() {
        return this.CanIncrementInternal();
    }

    private boolean CanExtendInternal() {
        if (!this.m_isInitialized) {
            return false;
        }
        int newLength = this.GetLengthInternal(this.m_currentVector) + 2;
        return newLength <= this.m_maxLength;
    }

    private boolean CanIncrementInternal() {
        if (!this.m_isInitialized) {
            return false;
        }
        if (this.m_currentVector >= 0xFFFFFFFFL) {
            return false;
        }
        int newLength = this.GetLengthInternal(this.m_currentVector + 1L);
        return newLength <= this.m_maxLength;
    }

    private int GetLengthInternal(long vectorValue) {
        int vectorSize = this.GetDigitCount(vectorValue);
        return this.m_baseVector.length() + 1 + vectorSize;
    }

    private int GetDigitCount(long value) {
        int digitCount;
        int n = digitCount = value < 0L ? 1 : 0;
        while (value != 0L) {
            value /= 10L;
            ++digitCount;
        }
        return digitCount;
    }

    public synchronized boolean SetValue(String cv) {
        boolean result = false;
        int maxLength = 0;
        if (cv.matches(s_validPattern_v1) && cv.length() <= 64) {
            maxLength = 64;
        } else if (cv.matches(s_validPattern_v2) && cv.length() <= 128) {
            maxLength = 128;
        } else {
            return false;
        }
        int lastDotPos = cv.lastIndexOf(".");
        if (lastDotPos == -1) {
            this.m_baseVector = cv;
            this.m_currentVector = 0L;
        } else {
            long currentVector = -1L;
            try {
                currentVector = Long.parseLong(cv.substring(lastDotPos + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (currentVector < 0L || currentVector > 0xFFFFFFFFL) {
                return false;
            }
            this.m_baseVector = cv.substring(0, lastDotPos);
            this.m_currentVector = currentVector;
        }
        this.m_maxLength = maxLength;
        this.m_isInitialized = true;
        return true;
    }
}

