/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.AbstractSettings;
import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.PartA;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.SettingsSync;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class CllSettings
extends AbstractSettings {
    private final SettingsSync settingsSync;

    public CllSettings(ClientTelemetry clientTelemetry, ILogger logger, SettingsSync settingsSync, PartA partA) {
        super(clientTelemetry, logger, partA);
        this.settingsSync = settingsSync;
        this.TAG = "AndroidCll-CllSettings";
        this.ETagSettingName = SettingsStore.Settings.CLLSETTINGSETAG;
        this.endpoint = SettingsStore.getCllSettingsAsString(SettingsStore.Settings.CLLSETTINGSURL);
        this.queryParam = "?iKey=" + partA.iKey + "&os=" + partA.osName + "&osVer=" + partA.osVer + "&deviceClass=" + partA.deviceExt.getDeviceClass() + "&deviceId=" + partA.deviceExt.getLocalId();
    }

    @Override
    public void ParseSettings(JSONObject resultJson) {
        try {
            if (resultJson != null && resultJson.has("settings")) {
                int refreshInterval = resultJson.getInt("refreshInterval") * 60;
                if (refreshInterval != SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.SYNCREFRESHINTERVAL)) {
                    SettingsStore.cllSettings.put(SettingsStore.Settings.SYNCREFRESHINTERVAL, refreshInterval);
                    this.settingsSync.nextExecution.cancel(false);
                    this.settingsSync.nextExecution = this.settingsSync.executor.scheduleAtFixedRate(this.settingsSync, SettingsStore.getCllSettingsAsLong(SettingsStore.Settings.SYNCREFRESHINTERVAL), SettingsStore.getCllSettingsAsLong(SettingsStore.Settings.SYNCREFRESHINTERVAL), TimeUnit.SECONDS);
                }
                JSONObject jsonSettings = (JSONObject)resultJson.get("settings");
                Iterator keys = jsonSettings.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = jsonSettings.getString(key);
                    try {
                        SettingsStore.updateCllSetting(SettingsStore.Settings.valueOf(key), value);
                        this.logger.info(this.TAG, "Json Settings, Key: " + key + " Value: " + value);
                    }
                    catch (Exception e) {
                        this.logger.warn(this.TAG, "Key: " + key + " was not found");
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(this.TAG, "An exception occurred while parsing settings");
        }
    }
}

