/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.AbstractHandler;
import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.FileStorage;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.IStorage;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public class NormalEventHandler
extends AbstractHandler {
    private final String TAG = "AndroidCll-NormalEventHandler";
    private ArrayBlockingQueue<Tuple<String, List<String>>> queueStorage;
    private final int queueSize = SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.NORMALEVENTMEMORYQUEUESIZE);

    public NormalEventHandler(ILogger logger, String filePath, ClientTelemetry clientTelemetry) {
        super(logger, filePath, clientTelemetry);
        this.fileStorage = new FileStorage(".norm.cllevent", logger, filePath, this);
        this.queueStorage = new ArrayBlockingQueue(this.queueSize);
    }

    @Override
    public synchronized void add(String event, List<String> ids) {
        Tuple<String, List<String>> tuple = new Tuple<String, List<String>>(event, ids);
        if (!this.queueStorage.offer(tuple)) {
            this.writeQueueToDisk();
            this.queueStorage.offer(tuple);
        }
    }

    @Override
    public void close() {
        this.logger.info("AndroidCll-NormalEventHandler", "Closing normal file");
        this.writeQueueToDisk();
        this.fileStorage.close();
    }

    @Override
    public void dispose(IStorage storage) {
        totalStorageUsed.getAndAdd(-1L * storage.size());
    }

    @Override
    public synchronized List<IStorage> getFilesForDraining() {
        List<IStorage> storageList;
        if (this.queueStorage.size() > 0) {
            this.writeQueueToDisk();
        }
        if (this.fileStorage.size() > 0L) {
            this.fileStorage.close();
            storageList = this.getFilesByExtensionForDraining(".norm.cllevent");
            this.fileStorage = new FileStorage(".norm.cllevent", this.logger, this.filePath, this);
        } else {
            storageList = this.getFilesByExtensionForDraining(".norm.cllevent");
        }
        return storageList;
    }

    synchronized void writeQueueToDisk() {
        try {
            ArrayList events = new ArrayList(this.queueSize);
            this.queueStorage.drainTo(events);
            this.logger.info("AndroidCll-NormalEventHandler", "Writing " + events.size() + " events to disk");
            for (Tuple serializedEvent : events) {
                boolean canAddResult = this.ensureCanAdd(serializedEvent, EventEnums.Persistence.PersistenceNormal);
                if (!canAddResult) {
                    this.clientTelemetry.IncrementEventsDroppedDueToQuota();
                    this.logger.warn("AndroidCll-NormalEventHandler", "Out of storage space for normal events. Logged event was dropped.");
                    continue;
                }
                if (!this.fileStorage.canAdd(serializedEvent)) {
                    this.logger.info("AndroidCll-NormalEventHandler", "Closing full file and opening a new one");
                    this.fileStorage.close();
                    this.fileStorage = new FileStorage(".norm.cllevent", this.logger, this.filePath, this);
                }
                this.fileStorage.add(serializedEvent);
                totalStorageUsed.getAndAdd(((String)serializedEvent.a).length());
            }
        }
        catch (Exception e) {
            this.logger.error("AndroidCll-NormalEventHandler", "Could not write events to disk");
        }
        this.fileStorage.flush();
    }
}

