/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.PartA;
import com.microsoft.cll.android.SettingsStore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractSettings {
    protected String endpoint;
    protected String queryParam;
    protected final ClientTelemetry clientTelemetry;
    protected final ILogger logger;
    protected String TAG = "AndroidCll-AbstractSettings";
    protected SettingsStore.Settings ETagSettingName;
    private final PartA partA;
    protected boolean disableUploadOn404 = false;

    protected AbstractSettings(ClientTelemetry clientTelemetry, ILogger logger, PartA partA) {
        this.clientTelemetry = clientTelemetry;
        this.logger = logger;
        this.partA = partA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getSettings() {
        URL url;
        this.logger.info(this.TAG, "Get Settings");
        try {
            url = new URL(this.endpoint + this.queryParam);
        }
        catch (MalformedURLException e) {
            this.logger.error(this.TAG, "Settings URL is invalid");
            return null;
        }
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                String line;
                String ETag;
                this.clientTelemetry.IncrementSettingsHttpAttempts();
                HttpsURLConnection httpConnection = (HttpsURLConnection)connection;
                int conTimeout = httpConnection.getConnectTimeout();
                int reqTimeout = httpConnection.getReadTimeout();
                httpConnection.setConnectTimeout(SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.HTTPTIMEOUTINTERVAL));
                httpConnection.setReadTimeout(SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.HTTPTIMEOUTINTERVAL));
                httpConnection.setRequestMethod("GET");
                httpConnection.setRequestProperty("Accept", "application/json");
                httpConnection.setRequestProperty("If-None-Match", SettingsStore.getCllSettingsAsString(this.ETagSettingName));
                long start = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US).getTimeInMillis();
                httpConnection.connect();
                long finish = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US).getTimeInMillis();
                long diff = finish - start;
                this.clientTelemetry.SetAvgSettingsLatencyMs((int)diff);
                this.clientTelemetry.SetMaxSettingsLatencyMs((int)diff);
                if (httpConnection.getResponseCode() == 404 && this.disableUploadOn404) {
                    this.logger.info(this.TAG, "Your iKey is invalid. Your events will not be sent!");
                    SettingsStore.updateCllSetting(SettingsStore.Settings.UPLOADENABLED, "false");
                } else if (httpConnection.getResponseCode() != 404 && this.disableUploadOn404) {
                    this.logger.info(this.TAG, "Your iKey is valid.");
                    SettingsStore.updateCllSetting(SettingsStore.Settings.UPLOADENABLED, "true");
                }
                if (httpConnection.getResponseCode() == 200 || httpConnection.getResponseCode() == 304) {
                    ETag = httpConnection.getHeaderField("ETAG");
                    if (ETag != null && !ETag.isEmpty()) {
                        SettingsStore.updateCllSetting(this.ETagSettingName, ETag);
                    }
                } else {
                    this.clientTelemetry.IncrementSettingsHttpFailures(httpConnection.getResponseCode());
                }
                if (httpConnection.getResponseCode() != 200) {
                    httpConnection.disconnect();
                    httpConnection = null;
                    connection = null;
                    ETag = null;
                    return ETag;
                }
                BufferedReader input = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
                StringBuilder result = new StringBuilder();
                while ((line = input.readLine()) != null) {
                    result.append(line);
                }
                input.close();
                httpConnection.disconnect();
                httpConnection = null;
                connection = null;
                JSONObject jSONObject = new JSONObject(result.toString());
                return jSONObject;
            }
        }
        catch (IOException e) {
            this.logger.error(this.TAG, e.getMessage());
            this.clientTelemetry.IncrementSettingsHttpFailures(-1);
        }
        catch (JSONException e) {
            this.logger.error(this.TAG, e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.getInputStream().close();
                }
                catch (Exception e) {
                    this.logger.error(this.TAG, e.getMessage());
                }
            }
        }
        return null;
    }

    public abstract void ParseSettings(JSONObject var1);
}

