/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems.commanding.nearshare;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperationWithProgress;
import com.microsoft.connecteddevices.CancellationToken;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.EventListener;
import com.microsoft.connecteddevices.EventSubscription;
import java.util.HashSet;

@Keep
class NearShareSenderEnumAsyncOperation<T extends Enum<T>, P>
extends AsyncOperationWithProgress<T, P> {
    private Creator<T> mCreator;
    private CancellationToken mCancellationToken;
    private EventSource<P> mEventSource = new EventSource();

    private NearShareSenderEnumAsyncOperation() {
    }

    NearShareSenderEnumAsyncOperation(Creator<T> creator) {
        this.mCreator = creator;
    }

    @Override
    final void complete(int value) {
        super.complete(this.mCreator.create(value));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = super.cancel(mayInterruptIfRunning);
        if (null != this.mCancellationToken) {
            this.mCancellationToken.cancel();
        }
        return result;
    }

    public void setCancellationToken(CancellationToken cancellationToken) {
        this.mCancellationToken = cancellationToken;
    }

    @Override
    @NonNull
    public Event<AsyncOperationWithProgress<T, P>, P> progress() {
        return this.mEventSource;
    }

    void notifyListeners(P progress) {
        this.mEventSource.notifyListeners(this, progress);
    }

    static interface Creator<T> {
        public T create(int var1);
    }

    private class EventSource<P>
    implements Event<AsyncOperationWithProgress<T, P>, P> {
        private final HashSet<EventListener<? super AsyncOperationWithProgress<T, P>, ? super P>> mListeners = new HashSet();

        private EventSource() {
        }

        @Override
        public synchronized EventSubscription subscribe(EventListener<? super AsyncOperationWithProgress<T, P>, ? super P> listener) {
            if (listener == null) {
                throw new IllegalArgumentException();
            }
            this.mListeners.add(listener);
            return () -> this.removeListener(listener);
        }

        synchronized void removeListener(EventListener<? super AsyncOperationWithProgress<T, P>, ? super P> listener) {
            this.mListeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyListeners(AsyncOperationWithProgress<T, P> source, P progress) {
            HashSet listeners;
            EventSource eventSource = this;
            synchronized (eventSource) {
                listeners = (HashSet)this.mListeners.clone();
            }
            for (EventListener listener : listeners) {
                listener.onEvent(source, progress);
            }
        }
    }
}

