/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems.commanding;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeEnumAsyncOperation;
import com.microsoft.connecteddevices.NativeEvent;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectAsyncOperation;
import com.microsoft.connecteddevices.NativeObjectEventListener;
import com.microsoft.connecteddevices.NativeUtils;
import com.microsoft.connecteddevices.remotesystems.AppServiceInfo;
import com.microsoft.connecteddevices.remotesystems.commanding.AppServiceClosedEventArgs;
import com.microsoft.connecteddevices.remotesystems.commanding.AppServiceConnectionStatus;
import com.microsoft.connecteddevices.remotesystems.commanding.AppServiceRequestReceivedEventArgs;
import com.microsoft.connecteddevices.remotesystems.commanding.AppServiceResponse;
import com.microsoft.connecteddevices.remotesystems.commanding.RemoteSystemConnectionRequest;
import com.microsoft.connecteddevices.remotesystems.commanding.StatelessAppServiceResponse;
import java.util.Map;

@Keep
public final class AppServiceConnection
extends NativeBase
implements AutoCloseable {
    private Event<AppServiceConnection, AppServiceClosedEventArgs> mServiceClosed = new NativeEvent<AppServiceConnection, AppServiceClosedEventArgs>(this, this::addServiceClosedListenerNative, this::removeServiceClosedListenerNative, AppServiceConnection::new, AppServiceClosedEventArgs::new);
    private Event<AppServiceConnection, AppServiceRequestReceivedEventArgs> mRequestReceived = new NativeEvent<AppServiceConnection, AppServiceRequestReceivedEventArgs>(this, this::addRequestReceivedListenerNative, this::removeRequestReceivedListenerNative, AppServiceConnection::new, AppServiceRequestReceivedEventArgs::new);

    AppServiceConnection(NativeObject nativeObject) {
        super(nativeObject);
    }

    public AppServiceConnection() {
        super(AppServiceConnection.createInstanceNative());
    }

    public AppServiceConnection(@NonNull AppServiceInfo appServiceInfo) {
        super(AppServiceConnection.createInstanceNative(appServiceInfo.getNativePointer()));
    }

    @Override
    public void close() {
        this.closeNative(this.getNativePointer());
    }

    @NonNull
    public AsyncOperation<AppServiceConnectionStatus> openRemoteAsync(@NonNull RemoteSystemConnectionRequest connection) {
        NativeEnumAsyncOperation<AppServiceConnectionStatus> operation = new NativeEnumAsyncOperation<AppServiceConnectionStatus>(AppServiceConnectionStatus::fromInt);
        this.openRemoteAsyncNative(this.getNativePointer(), NativeUtils.getNativePointer(connection), operation);
        return operation;
    }

    @NonNull
    public AsyncOperation<AppServiceResponse> sendMessageAsync(@NonNull Map<String, Object> message) {
        NativeObjectAsyncOperation<AppServiceResponse> operation = new NativeObjectAsyncOperation<AppServiceResponse>(AppServiceResponse::new);
        this.sendMessageAsyncNative(this.getNativePointer(), message, operation);
        return operation;
    }

    @NonNull
    public static AsyncOperation<StatelessAppServiceResponse> sendStatelessMessageAsync(@NonNull AppServiceInfo appServiceInfo, @NonNull RemoteSystemConnectionRequest connectionRequest, @NonNull Map<String, Object> message) {
        NativeObjectAsyncOperation<StatelessAppServiceResponse> operation = new NativeObjectAsyncOperation<StatelessAppServiceResponse>(StatelessAppServiceResponse::new);
        AppServiceConnection.sendStatelessMessageAsyncNative(NativeUtils.getNativePointer(appServiceInfo), NativeUtils.getNativePointer(connectionRequest), message, operation);
        return operation;
    }

    @NonNull
    public AppServiceInfo getAppServiceInfo() {
        return NativeObject.toSpecific(this.getAppServiceInfoNative(this.getNativePointer()), AppServiceInfo.class);
    }

    public void setAppServiceInfo(@NonNull AppServiceInfo appServiceInfo) {
        this.setAppServiceInfoNative(this.getNativePointer(), appServiceInfo.getNativePointer());
    }

    @NonNull
    public Event<AppServiceConnection, AppServiceRequestReceivedEventArgs> requestReceived() {
        return this.mRequestReceived;
    }

    @NonNull
    public Event<AppServiceConnection, AppServiceClosedEventArgs> serviceClosed() {
        return this.mServiceClosed;
    }

    private static native NativeObject createInstanceNative();

    private static native NativeObject createInstanceNative(long var0);

    private native void closeNative(long var1);

    private native void openRemoteAsyncNative(long var1, long var3, AsyncOperation<AppServiceConnectionStatus> var5);

    private native void sendMessageAsyncNative(long var1, Map var3, AsyncOperation<AppServiceResponse> var4);

    private static native void sendStatelessMessageAsyncNative(long var0, long var2, Map var4, AsyncOperation<StatelessAppServiceResponse> var5);

    private native NativeObject getAppServiceInfoNative(long var1);

    private native void setAppServiceInfoNative(long var1, long var3);

    private native long addRequestReceivedListenerNative(long var1, NativeObjectEventListener<AppServiceConnection, AppServiceRequestReceivedEventArgs> var3);

    private native void removeRequestReceivedListenerNative(long var1, long var3);

    private native long addServiceClosedListenerNative(long var1, NativeObjectEventListener<AppServiceConnection, AppServiceClosedEventArgs> var3);

    private native void removeServiceClosedListenerNative(long var1, long var3);
}

