/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import android.support.annotation.RestrictTo;
import com.microsoft.connecteddevices.ErrorCode;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativePointerHolder;
import com.microsoft.connecteddevices.SDKLoader;
import com.microsoft.connecteddevices.SdkException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class NativeObject
extends SDKLoader
implements NativePointerHolder,
AutoCloseable {
    private long mRawPointer;

    NativeObject(long rawPointer) {
        if (rawPointer != 0L) {
            this.addRef(rawPointer);
            this.mRawPointer = rawPointer;
        }
    }

    public static <T extends NativeBase> T toSpecific(NativeObject nativeObject, Creator<T> creator) {
        if (creator == null || nativeObject == null || nativeObject.getNativePointer() == 0L) {
            return null;
        }
        return (T)((NativeBase)creator.create(nativeObject));
    }

    public static <T extends NativeBase> T toSpecific(NativeObject nativeObject, Class<T> desiredClass) {
        return (T)NativeObject.toSpecific(nativeObject, (NativeObject obj) -> {
            try {
                Constructor constructor = desiredClass.getDeclaredConstructor(NativeObject.class);
                constructor.setAccessible(true);
                return (NativeBase)constructor.newInstance(obj);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new SdkException(ErrorCode.UNKNOWN, "Failed to construct desired class " + desiredClass.toString() + ", message: " + e.getMessage());
            }
        });
    }

    public static <T extends NativeBase> List<T> toSpecificList(NativeObject[] nativeObjects, Creator<T> creator) {
        if (nativeObjects == null) {
            return null;
        }
        ArrayList<T> toReturn = new ArrayList<T>(nativeObjects.length);
        for (int i = 0; i < nativeObjects.length; ++i) {
            toReturn.add(NativeObject.toSpecific(nativeObjects[i], creator));
        }
        return toReturn;
    }

    public int hashCode() {
        return Objects.hash(this.mRawPointer);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NativeObject)) {
            return false;
        }
        return ((NativeObject)object).mRawPointer == this.mRawPointer;
    }

    @Override
    public void close() {
        long tempRawPointer = this.mRawPointer;
        if (tempRawPointer != 0L) {
            this.mRawPointer = 0L;
            this.release(tempRawPointer);
        }
    }

    @Override
    public long getNativePointer() {
        return this.mRawPointer;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private native void addRef(long var1);

    private native void release(long var1);

    public static interface Creator<T> {
        public T create(NativeObject var1);
    }
}

