/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.annotation.Keep;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Locale;

@Keep
class DeviceProperties {
    DeviceProperties() {
    }

    static String getPlatformDeviceName(Context context) {
        String bluetoothName = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"bluetooth_name");
        return bluetoothName != null ? bluetoothName : Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)"wifi_p2p_device_name");
    }

    static String getPlatformOsLocale(Context context) {
        Locale locale = Locale.getDefault();
        return locale.getLanguage() + "-" + locale.getCountry();
    }

    static String getIPv4Address(Context context) {
        String result = "0.0.0.0";
        try {
            for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress address : Collections.list(iface.getInetAddresses())) {
                    String ip;
                    if (address.isLoopbackAddress() || (ip = address.getHostAddress()).indexOf(":") >= 0) continue;
                    result = ip;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return result;
    }

    static boolean hasTelephonyCapability(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }
}

