/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.ConnectedDevicesAccountManager;
import com.microsoft.connecteddevices.ConnectedDevicesNotificationRegistrationManager;
import com.microsoft.connecteddevices.ConnectedDevicesProcessNotificationOperation;
import com.microsoft.connecteddevices.ConversionHelpers;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeObject;
import java.util.Map;
import org.json.JSONException;

@Keep
public final class ConnectedDevicesPlatform
extends NativeBase {
    ConnectedDevicesPlatform(NativeObject nativeObject) {
        super(nativeObject);
    }

    public ConnectedDevicesPlatform(@NonNull Context context) {
        super(ConnectedDevicesPlatform.createInstanceNative(context.getApplicationContext()));
    }

    @NonNull
    public ConnectedDevicesAccountManager getAccountManager() {
        return NativeObject.toSpecific(this.getAccountManagerNative(this.getNativePointer()), ConnectedDevicesAccountManager.class);
    }

    @Deprecated
    @NonNull
    public ConnectedDevicesProcessNotificationOperation processNotification(@NonNull Bundle bundle) {
        String notification;
        try {
            notification = ConversionHelpers.bundleToJSONString(bundle);
        }
        catch (JSONException e) {
            notification = "";
        }
        return NativeObject.toSpecific(this.processNotificationNative(this.getNativePointer(), notification), ConnectedDevicesProcessNotificationOperation.class);
    }

    @NonNull
    public ConnectedDevicesProcessNotificationOperation processNotification(@NonNull Map map) {
        String notification;
        try {
            notification = ConversionHelpers.mapToJSONString(map);
        }
        catch (JSONException e) {
            notification = "";
        }
        return NativeObject.toSpecific(this.processNotificationNative(this.getNativePointer(), notification), ConnectedDevicesProcessNotificationOperation.class);
    }

    public void start() {
        this.startNative(this.getNativePointer());
    }

    @NonNull
    public AsyncOperation<Void> shutdownAsync() {
        AsyncOperation<Void> result = new AsyncOperation<Void>();
        this.shutdownAsyncNative(this.getNativePointer(), result);
        return result;
    }

    @NonNull
    public ConnectedDevicesNotificationRegistrationManager getNotificationRegistrationManager() {
        return NativeObject.toSpecific(this.getNotificationRegistrationManagerNative(this.getNativePointer()), ConnectedDevicesNotificationRegistrationManager.class);
    }

    private static native NativeObject createInstanceNative(Context var0);

    private native NativeObject getAccountManagerNative(long var1);

    private native NativeObject processNotificationNative(long var1, String var3);

    private native void startNative(long var1);

    private native void shutdownAsyncNative(long var1, AsyncOperation<Void> var3);

    private native NativeObject getNotificationRegistrationManagerNative(long var1);
}

