/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.RequiresPermission;
import com.microsoft.connecteddevices.BluetoothWrapper;
import com.microsoft.connecteddevices.BluetoothWrapperImpl;
import java.util.Arrays;

@Keep
final class BluetoothWrapperImplLegacy
extends BluetoothWrapperImpl {
    private static BluetoothAdapter.LeScanCallback _leScanCallback;

    BluetoothWrapperImplLegacy() {
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public boolean initializeBLE(Context context) {
        if (!this.shouldInitialize(context)) {
            return false;
        }
        if (!super.initializeBLE(context)) {
            return false;
        }
        _leScanCallback = new LeScanCallback();
        return true;
    }

    @Override
    public boolean isInitialized() {
        return _leScanCallback != null && super.isInitialized();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public void startScan(Context context) {
        if (this.ensureInitialized(context, "startScan")) {
            boolean scanStarted = BluetoothAdapter.getDefaultAdapter().startLeScan(_leScanCallback);
            if (scanStarted) {
                this.setScanStarted(true);
            } else {
                BluetoothWrapper.traceWarning("scan did not start successfully");
            }
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public void stopScan(Context context) {
        if (this.ensureInitialized(context, "stopScan")) {
            this.stopScanInternal();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    boolean stopScanInternal() {
        boolean stopRequested = false;
        if (!this.wasScanStarted()) {
            BluetoothWrapper.traceWarning("Called 'stopScan' before starting a scan");
        }
        if (_leScanCallback == null) {
            BluetoothWrapper.traceWarning("Unable to 'stopScan': Scan callback is null");
        } else {
            try {
                BluetoothAdapter.getDefaultAdapter().stopLeScan(_leScanCallback);
                stopRequested = true;
            }
            catch (IllegalStateException e) {
                BluetoothWrapper.traceWarning("Failed to stop BLE scan. message: " + e.getMessage());
            }
        }
        return this.setScanStarted(!stopRequested);
    }

    @Override
    public boolean hasRequiredPermissions(Context context) {
        boolean hasBluetoothAdminPermission;
        boolean bl = hasBluetoothAdminPermission = context.checkCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN") == 0;
        if (!hasBluetoothAdminPermission) {
            BluetoothWrapper.traceWarning("Required permission BLUETOOTH_ADMIN has not been granted");
        }
        return hasBluetoothAdminPermission && super.hasRequiredPermissions(context);
    }

    private byte[] parseMicrosoftManufacturerSpecificData(byte[] scanRecord) {
        byte[] manufacturerData = null;
        int currentPosition = 0;
        while (currentPosition < scanRecord.length) {
            int structureLength = scanRecord[currentPosition] & 0xFF;
            ++currentPosition;
            if (structureLength == 0) break;
            int type = scanRecord[currentPosition] & 0xFF;
            ++currentPosition;
            int advertisingDataLength = structureLength - 1;
            if (advertisingDataLength == 0) continue;
            if (type == 255) {
                int currentId = ((scanRecord[currentPosition + 1] & 0xFF) << 8) + (scanRecord[currentPosition] & 0xFF);
                currentPosition += 2;
                advertisingDataLength -= 2;
                if (currentId == 6) {
                    manufacturerData = Arrays.copyOfRange(scanRecord, currentPosition, advertisingDataLength);
                    break;
                }
            }
            currentPosition += advertisingDataLength;
        }
        return manufacturerData;
    }

    private class LeScanCallback
    implements BluetoothAdapter.LeScanCallback {
        private LeScanCallback() {
        }

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            try {
                byte[] manufacturerData = BluetoothWrapperImplLegacy.this.parseMicrosoftManufacturerSpecificData(scanRecord);
                BluetoothWrapperImplLegacy.this.handleScanResult(device, manufacturerData, rssi);
            }
            catch (Exception e) {
                BluetoothWrapper.traceWarning("Exception handling scan result. message: " + e.getMessage());
            }
        }
    }
}

