/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.Keep;

@Keep
class AFCDataAceessLayer
extends SQLiteOpenHelper {
    private Context mContext;
    private String mDefaultCurrentSettingsMetadata;
    private boolean mIsNewDbCreated = false;

    private native String getCreateSqlNative();

    private native String getCreateViewSqlNative();

    private native int getDesiredSchemaVersionNative();

    private native String[] getUpgradeSqlArrayNative(int var1);

    private native String getCurrentSettingsMetadataInsertQuery();

    public AFCDataAceessLayer(Context context, String path, int dbVersion, String defaultCurrentSettingsMetadata) {
        super(context, path, null, dbVersion);
        this.mContext = context;
        this.mDefaultCurrentSettingsMetadata = defaultCurrentSettingsMetadata;
    }

    public void onCreate(SQLiteDatabase db) {
        this.CreateDB(db);
    }

    private void ThrowIfNull(Object obj, String context) {
        if (obj == null) {
            throw new IllegalArgumentException(context);
        }
    }

    private void CreateDB(SQLiteDatabase db) {
        String[] viewSqlArray;
        String[] createSqlArray;
        String createSql = this.getCreateSqlNative();
        this.ThrowIfNull(createSql, "getCreateSqlNative failed");
        for (String sql : createSqlArray = createSql.split(";")) {
            db.execSQL(sql);
        }
        String viewSql = this.getCreateViewSqlNative();
        this.ThrowIfNull(viewSql, "getCreateViewSqlNative failed");
        for (String sql : viewSqlArray = viewSql.split(";")) {
            db.execSQL(sql);
        }
        db.setVersion(this.getDesiredSchemaVersionNative());
        String currentSettingsInsertQuery = this.getCurrentSettingsMetadataInsertQuery();
        this.ThrowIfNull(currentSettingsInsertQuery, "getCurrentSettingsMetadataInsertQuery failed");
        db.execSQL(currentSettingsInsertQuery, new Object[]{this.mDefaultCurrentSettingsMetadata});
        this.mIsNewDbCreated = true;
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        String[] upgradeStatements = this.getUpgradeSqlArrayNative(oldVersion);
        try {
            this.ThrowIfNull(upgradeStatements, "getUpgradeSqlArrayNative failed");
            for (String statement : upgradeStatements) {
                String[] sqlArray;
                if (statement == null) continue;
                for (String sql : sqlArray = statement.split(";")) {
                    db.execSQL(sql);
                }
            }
        }
        catch (Exception e) {
            this.CreateDB(db);
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db.getVersion() != this.getDesiredSchemaVersionNative()) {
            this.CreateDB(db);
        }
    }

    public synchronized boolean IsNewDbCreated() {
        boolean value = this.mIsNewDbCreated;
        this.mIsNewDbCreated = false;
        return value;
    }
}

