/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.AutoDetectSourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.HybridSpeechConfig;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.translation.SpeechTranslationConfig;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionResult;
import com.microsoft.cognitiveservices.speech.translation.TranslationSynthesisEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class TranslationRecognizer
extends Recognizer {
    public final EventHandlerImpl<TranslationRecognitionEventArgs> recognizing;
    public final EventHandlerImpl<TranslationRecognitionEventArgs> recognized;
    public final EventHandlerImpl<TranslationRecognitionCanceledEventArgs> canceled;
    public final EventHandlerImpl<TranslationSynthesisEventArgs> synthesizing;
    static Set<TranslationRecognizer> translationRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;
    SafeHandle translationSynthesisHandle;

    public TranslationRecognizer(SpeechTranslationConfig speechTranslationConfig) {
        super(null, speechTranslationConfig.getTokenCredential());
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(speechTranslationConfig, "stc");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), speechTranslationConfig.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(SpeechTranslationConfig speechTranslationConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig) {
        super(null, speechTranslationConfig.getTokenCredential());
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(speechTranslationConfig, "stc");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromAutoDetectSourceLangConfig(super.getImpl(), speechTranslationConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(SpeechTranslationConfig speechTranslationConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig, AudioConfig audioConfig) {
        super(audioConfig, speechTranslationConfig.getTokenCredential());
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(speechTranslationConfig, "stc");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromAutoDetectSourceLangConfig(super.getImpl(), speechTranslationConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromAutoDetectSourceLangConfig(super.getImpl(), speechTranslationConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public TranslationRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig) {
        super(null, null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(HybridSpeechConfig hybridSpeechConfig) {
        super(null, null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(hybridSpeechConfig, "hybridSpeechConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), hybridSpeechConfig.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(SpeechTranslationConfig speechTranslationConfig, AudioConfig audioConfig) {
        super(audioConfig, speechTranslationConfig.getTokenCredential());
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(speechTranslationConfig, "stc");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), speechTranslationConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), speechTranslationConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public TranslationRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AudioConfig audioConfig) {
        super(audioConfig, null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public TranslationRecognizer(HybridSpeechConfig hybridSpeechConfig, AudioConfig audioConfig) {
        super(audioConfig, null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(hybridSpeechConfig, "hybridSpeechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), hybridSpeechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), hybridSpeechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public TranslationRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig) {
        super(null, null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromAutoDetectSourceLangConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLanguageConfig, AudioConfig audioConfig) {
        super(audioConfig, null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        Contracts.throwIfNull(autoDetectSourceLanguageConfig, "autoDetectSourceLangConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromAutoDetectSourceLangConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromAutoDetectSourceLangConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), autoDetectSourceLanguageConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public void addTargetLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        Contracts.throwIfFail(this.addTargetLanguage(super.getImpl(), string));
    }

    public void removeTargetLanguage(String string) {
        Contracts.throwIfNullOrWhitespace(string, "value");
        Contracts.throwIfFail(this.removeTargetLanguage(super.getImpl(), string));
    }

    public ArrayList<String> getTargetLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_TranslationToLanguages);
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public String getVoiceName() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_TranslationVoice);
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<TranslationRecognitionResult> recognizeOnceAsync() {
        final TranslationRecognizer translationRecognizer = this;
        return AsyncThreadService.submit(new Callable<TranslationRecognitionResult>(){

            @Override
            public TranslationRecognitionResult call() {
                final TranslationRecognitionResult[] translationRecognitionResultArray = new TranslationRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        translationRecognitionResultArray[0] = new TranslationRecognitionResult(translationRecognizer.recognize());
                    }
                };
                translationRecognizer.doAsyncRecognitionAction(runnable);
                return translationRecognitionResultArray[0];
            }
        });
    }

    public Future<Void> startContinuousRecognitionAsync() {
        final TranslationRecognizer translationRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        translationRecognizer.startContinuousRecognition(TranslationRecognizer.this.getImpl());
                    }
                };
                translationRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopContinuousRecognitionAsync() {
        final TranslationRecognizer translationRecognizer = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        translationRecognizer.stopContinuousRecognition(TranslationRecognizer.this.getImpl());
                    }
                };
                translationRecognizer.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    @Override
    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.translationSynthesisHandle != null) {
                this.translationSynthesisHandle.close();
                this.translationSynthesisHandle = null;
            }
            translationRecognizerObjects.remove(this);
            super.dispose(bl);
        }
    }

    private void initialize() {
        final TranslationRecognizer translationRecognizer = this;
        this.translationSynthesisHandle = new SafeHandle(translationRecognizer.getImpl().getValue(), SafeHandleType.TranslationSynthesis);
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.recognizingSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.recognizedSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        this.synthesizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.synthesizingSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.canceledSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.sessionStartedSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.sessionStoppedSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        this.tokenRequested.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.tokenRefreshSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.speechStartDetectedSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(translationRecognizer);
                Contracts.throwIfFail(TranslationRecognizer.this.speechEndDetectedSetCallback(translationRecognizer.getImpl().getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(translationRecognizer.getImpl(), intRef));
        this.propertyHandle = new PropertyCollection(intRef);
        this.setUpTokenRefreshCallback(this.propertyHandle);
    }

    private void recognizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionEventArgs translationRecognitionEventArgs = new TranslationRecognitionEventArgs(l, true);
            EventHandlerImpl<TranslationRecognitionEventArgs> eventHandlerImpl = this.recognizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, translationRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionEventArgs translationRecognitionEventArgs = new TranslationRecognitionEventArgs(l, true);
            EventHandlerImpl<TranslationRecognitionEventArgs> eventHandlerImpl = this.recognized;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, translationRecognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionCanceledEventArgs translationRecognitionCanceledEventArgs = new TranslationRecognitionCanceledEventArgs(l, true);
            EventHandlerImpl<TranslationRecognitionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, translationRecognitionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationSynthesisEventArgs translationSynthesisEventArgs = new TranslationSynthesisEventArgs(l, true);
            EventHandlerImpl<TranslationSynthesisEventArgs> eventHandlerImpl = this.synthesizing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, translationSynthesisEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createTranslationRecognizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long createTranslationRecognizerFromAutoDetectSourceLangConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3, SafeHandle var4);

    private final native long synthesizingSetCallback(long var1);

    private final native long addTargetLanguage(SafeHandle var1, String var2);

    private final native long removeTargetLanguage(SafeHandle var1, String var2);
}

