/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.transcription.Meeting;
import com.microsoft.cognitiveservices.speech.transcription.MeetingTranscriptionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.MeetingTranscriptionEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class MeetingTranscriber
extends Recognizer {
    public final EventHandlerImpl<MeetingTranscriptionEventArgs> transcribing;
    public final EventHandlerImpl<MeetingTranscriptionEventArgs> transcribed;
    public final EventHandlerImpl<MeetingTranscriptionCanceledEventArgs> canceled;
    static Set<MeetingTranscriber> meetingTranscriberObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;

    public MeetingTranscriber() {
        super(null, null);
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createMeetingTranscriberFromConfig(super.getImpl(), null));
        this.initialize();
    }

    public MeetingTranscriber(AudioConfig audioConfig) {
        super(audioConfig, null);
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createMeetingTranscriberFromConfig(super.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createMeetingTranscriberFromConfig(super.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public OutputFormat getOutputFormat() {
        if (this.propertyHandle.getProperty(PropertyId.SpeechServiceResponse_RequestDetailedResultTrueFalse).equals("true")) {
            return OutputFormat.Detailed;
        }
        return OutputFormat.Simple;
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Void> joinMeetingAsync(Meeting meeting) {
        final MeetingTranscriber meetingTranscriber = this;
        final Meeting meeting2 = meeting;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        meetingTranscriber.joinMeeting(MeetingTranscriber.this.getImpl(), meeting2.getImpl());
                    }
                };
                meetingTranscriber.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> leaveMeetingAsync() {
        final MeetingTranscriber meetingTranscriber = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        meetingTranscriber.leaveMeeting(MeetingTranscriber.this.getImpl());
                    }
                };
                meetingTranscriber.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startTranscribingAsync() {
        final MeetingTranscriber meetingTranscriber = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        meetingTranscriber.startContinuousRecognition(MeetingTranscriber.this.getImpl());
                    }
                };
                meetingTranscriber.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopTranscribingAsync() {
        final MeetingTranscriber meetingTranscriber = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        meetingTranscriber.stopContinuousRecognition(MeetingTranscriber.this.getImpl());
                    }
                };
                meetingTranscriber.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    @Override
    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            meetingTranscriberObjects.remove(this);
            super.dispose(bl);
        }
    }

    private void initialize() {
        final MeetingTranscriber meetingTranscriber = this;
        this.transcribing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(meetingTranscriber);
                Contracts.throwIfFail(MeetingTranscriber.this.recognizingSetCallback(meetingTranscriber.getImpl().getValue()));
            }
        });
        this.transcribed.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(meetingTranscriber);
                Contracts.throwIfFail(MeetingTranscriber.this.recognizedSetCallback(meetingTranscriber.getImpl().getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(meetingTranscriber);
                Contracts.throwIfFail(MeetingTranscriber.this.canceledSetCallback(meetingTranscriber.getImpl().getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(meetingTranscriber);
                Contracts.throwIfFail(MeetingTranscriber.this.sessionStartedSetCallback(meetingTranscriber.getImpl().getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(meetingTranscriber);
                Contracts.throwIfFail(MeetingTranscriber.this.sessionStoppedSetCallback(meetingTranscriber.getImpl().getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(meetingTranscriber);
                Contracts.throwIfFail(MeetingTranscriber.this.speechStartDetectedSetCallback(meetingTranscriber.getImpl().getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(meetingTranscriber);
                Contracts.throwIfFail(MeetingTranscriber.this.speechEndDetectedSetCallback(meetingTranscriber.getImpl().getValue()));
            }
        });
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(meetingTranscriber.getImpl(), intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private void recognizingEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            MeetingTranscriptionEventArgs meetingTranscriptionEventArgs = new MeetingTranscriptionEventArgs(l, true);
            EventHandlerImpl<MeetingTranscriptionEventArgs> eventHandlerImpl = this.transcribing;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, meetingTranscriptionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            MeetingTranscriptionEventArgs meetingTranscriptionEventArgs = new MeetingTranscriptionEventArgs(l, true);
            EventHandlerImpl<MeetingTranscriptionEventArgs> eventHandlerImpl = this.transcribed;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, meetingTranscriptionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            MeetingTranscriptionCanceledEventArgs meetingTranscriptionCanceledEventArgs = new MeetingTranscriptionCanceledEventArgs(l, true);
            EventHandlerImpl<MeetingTranscriptionCanceledEventArgs> eventHandlerImpl = this.canceled;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, meetingTranscriptionCanceledEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createMeetingTranscriberFromConfig(SafeHandle var1, SafeHandle var2);

    private final native long joinMeeting(SafeHandle var1, SafeHandle var2);

    private final native long leaveMeeting(SafeHandle var1);
}

