/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.time.OffsetDateTime;
import java.util.concurrent.atomic.AtomicInteger;

public class Recognizer
implements AutoCloseable {
    protected AtomicInteger eventCounter = new AtomicInteger(0);
    protected static final String AUTH_TOKEN_EXPIRY_PROPERTY = "service.auth.token.expirems";
    protected static final String AUTH_TOKEN_ERROR_PROPERTY = "service.auth.token.lasterror";
    protected static final String AUTH_TOKEN_REFRESH_INTERVAL_MS_PROPERTY = "service.auth.token.refreshintervalms";
    protected final EventHandlerImpl<SessionEventArgs> tokenRequested = new EventHandlerImpl(this.eventCounter);
    private final TokenCredential tokenCredential;
    private static final String[] TOKEN_REQUEST_SCOPES = new String[]{"https://cognitiveservices.azure.com/.default"};
    public final EventHandlerImpl<SessionEventArgs> sessionStarted = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SessionEventArgs> sessionStopped = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<RecognitionEventArgs> speechStartDetected = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<RecognitionEventArgs> speechEndDetected = new EventHandlerImpl(this.eventCounter);
    private SafeHandle recoHandle = null;
    protected boolean disposed = false;
    private AudioConfig audioInputKeepAlive = null;
    private final Object recognizerLock = new Object();
    private int activeAsyncRecognitionCounter = 0;

    protected Recognizer(AudioConfig audioConfig, TokenCredential tokenCredential) {
        AsyncThreadService.initialize();
        this.recoHandle = new SafeHandle(0L, SafeHandleType.Recognizer);
        this.tokenCredential = tokenCredential;
        this.audioInputKeepAlive = audioConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.recognizerLock;
        synchronized (object) {
            if (this.activeAsyncRecognitionCounter != 0) {
                throw new IllegalStateException("Cannot dispose a recognizer while async recognition is running. Await async recognitions to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public SafeHandle getImpl() {
        return this.recoHandle;
    }

    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (this.recoHandle != null) {
            this.recoHandle.close();
            this.recoHandle = null;
        }
        AsyncThreadService.shutdown();
        this.audioInputKeepAlive = null;
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAsyncRecognitionAction(Runnable runnable) {
        Object object = this.recognizerLock;
        synchronized (object) {
            ++this.activeAsyncRecognitionCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            runnable.run();
        }
        finally {
            object = this.recognizerLock;
            synchronized (object) {
                --this.activeAsyncRecognitionCounter;
            }
        }
    }

    protected long recognize() {
        Contracts.throwIfNull(this.recoHandle, "Invalid recognizer handle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.recognizeOnce(this.recoHandle, intRef));
        return intRef.getValue();
    }

    protected void sessionStartedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SessionEventArgs sessionEventArgs = new SessionEventArgs(l, true);
            EventHandlerImpl<SessionEventArgs> eventHandlerImpl = this.sessionStarted;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, sessionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void sessionStoppedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SessionEventArgs sessionEventArgs = new SessionEventArgs(l, true);
            EventHandlerImpl<SessionEventArgs> eventHandlerImpl = this.sessionStopped;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, sessionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void tokenRefreshEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SessionEventArgs sessionEventArgs = new SessionEventArgs(l, true);
            EventHandlerImpl<SessionEventArgs> eventHandlerImpl = this.tokenRequested;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, sessionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void speechStartDetectedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            RecognitionEventArgs recognitionEventArgs = new RecognitionEventArgs(l, true);
            EventHandlerImpl<RecognitionEventArgs> eventHandlerImpl = this.speechStartDetected;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, recognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void speechEndDetectedEventCallback(long l) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            RecognitionEventArgs recognitionEventArgs = new RecognitionEventArgs(l, true);
            EventHandlerImpl<RecognitionEventArgs> eventHandlerImpl = this.speechEndDetected;
            if (eventHandlerImpl != null) {
                eventHandlerImpl.fireEvent(this, recognitionEventArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setUpTokenRefreshCallback(PropertyCollection propertyCollection) {
        if (this.tokenCredential == null || propertyCollection == null) {
            return;
        }
        this.tokenRequested.addEventListener((object, sessionEventArgs) -> this.updateAuthToken(propertyCollection));
        propertyCollection.setProperty(AUTH_TOKEN_EXPIRY_PROPERTY, "infinite");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAuthToken(PropertyCollection propertyCollection) {
        if (propertyCollection == null || this.tokenCredential == null) {
            return;
        }
        String string = propertyCollection.getProperty(PropertyId.SpeechServiceAuthorization_Token);
        String string2 = propertyCollection.getProperty(AUTH_TOKEN_EXPIRY_PROPERTY, "");
        String string3 = propertyCollection.getProperty(AUTH_TOKEN_REFRESH_INTERVAL_MS_PROPERTY, "");
        try {
            AccessToken accessToken = (AccessToken)this.tokenCredential.getToken(new TokenRequestContext().addScopes(TOKEN_REQUEST_SCOPES)).block();
            string = accessToken.getToken();
            if (string3 != null && !string3.isEmpty()) {
                try {
                    int n = Integer.parseInt(string3);
                    string2 = String.valueOf(OffsetDateTime.now().plusSeconds((long)n / 1000L).toInstant().toEpochMilli());
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = String.valueOf(accessToken.getExpiresAt().toInstant().toEpochMilli());
                }
            } else {
                string2 = String.valueOf(accessToken.getExpiresAt().toInstant().toEpochMilli());
            }
            propertyCollection.setProperty(AUTH_TOKEN_ERROR_PROPERTY, "");
        }
        catch (Exception exception) {
            propertyCollection.setProperty(AUTH_TOKEN_ERROR_PROPERTY, exception.toString());
        }
        finally {
            propertyCollection.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
            propertyCollection.setProperty(AUTH_TOKEN_EXPIRY_PROPERTY, string2);
        }
    }

    protected final native long startContinuousRecognition(SafeHandle var1);

    protected final native long stopContinuousRecognition(SafeHandle var1);

    protected final native long startKeywordRecognition(SafeHandle var1, SafeHandle var2);

    protected final native long stopKeywordRecognition(SafeHandle var1);

    protected final native long recognizingSetCallback(long var1);

    protected final native long recognizedSetCallback(long var1);

    protected final native long canceledSetCallback(long var1);

    protected final native long sessionStartedSetCallback(long var1);

    protected final native long sessionStoppedSetCallback(long var1);

    protected final native long tokenRefreshSetCallback(long var1);

    protected final native long speechStartDetectedSetCallback(long var1);

    protected final native long speechEndDetectedSetCallback(long var1);

    protected final native long getPropertyBagFromRecognizerHandle(SafeHandle var1, IntRef var2);

    private final native long recognizeOnce(SafeHandle var1, IntRef var2);
}

