/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.transcription.Participant;
import com.microsoft.cognitiveservices.speech.transcription.User;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class Meeting
implements AutoCloseable {
    private SafeHandle meetingHandle;
    private boolean disposed = false;
    private final Object meetingLock = new Object();
    private int activeAsyncMeetingCounter = 0;
    private PropertyCollection propertyHandle;

    public static Future<Meeting> createMeetingAsync(SpeechConfig speechConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        final SpeechConfig speechConfig2 = speechConfig;
        AsyncThreadService.initialize();
        return AsyncThreadService.submit(new Callable<Meeting>(){

            @Override
            public Meeting call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(Meeting.createMeetingFromConfig(intRef, speechConfig2.getImpl(), ""));
                return new Meeting(intRef.getValue());
            }
        });
    }

    public static Future<Meeting> createMeetingAsync(SpeechConfig speechConfig, String string) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(string, "meetingId");
        final String string2 = string;
        final SpeechConfig speechConfig2 = speechConfig;
        AsyncThreadService.initialize();
        return AsyncThreadService.submit(new Callable<Meeting>(){

            @Override
            public Meeting call() {
                IntRef intRef = new IntRef(0L);
                Contracts.throwIfFail(Meeting.createMeetingFromConfig(intRef, speechConfig2.getImpl(), string2));
                return new Meeting(intRef.getValue());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.meetingLock;
        synchronized (object) {
            if (this.activeAsyncMeetingCounter != 0) {
                throw new IllegalStateException("Cannot dispose a recognizer while async recognition is running. Await async recognitions to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public String getMeetingId() {
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getMeetingId(this.meetingHandle, stringRef));
        return stringRef.getValue();
    }

    public void setAuthorizationToken(String string) {
        Contracts.throwIfNullOrWhitespace(string, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, string);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Participant> addParticipantAsync(Participant participant) {
        final Participant participant2 = participant;
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Participant>(){

            @Override
            public Participant call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.addParticipant(Meeting.this.meetingHandle, participant2.getImpl()));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return participant2;
            }
        });
    }

    public Future<Participant> addParticipantAsync(final String string) {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Participant>(){

            @Override
            public Participant call() {
                final Participant[] participantArray = new Participant[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Participant participant = Participant.from(string);
                        Contracts.throwIfFail(Meeting.this.addParticipant(Meeting.this.meetingHandle, participant.getImpl()));
                        participantArray[0] = participant;
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return participantArray[0];
            }
        });
    }

    public Future<User> addParticipantAsync(final User user) {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<User>(){

            @Override
            public User call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.addParticipantByUser(Meeting.this.meetingHandle, user.getImpl()));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return user;
            }
        });
    }

    public Future<Void> removeParticipantAsync(User user) {
        final User user2 = user;
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.removeParticipantByUser(Meeting.this.meetingHandle, user2.getImpl()));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> removeParticipantAsync(Participant participant) {
        final Participant participant2 = participant;
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.removeParticipant(Meeting.this.meetingHandle, participant2.getImpl()));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> removeParticipantAsync(String string) {
        final String string2 = string;
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.removeParticipantByUserId(Meeting.this.meetingHandle, string2));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> endMeetingAsync() {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.endMeeting(Meeting.this.meetingHandle));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startMeetingAsync() {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.startMeeting(Meeting.this.meetingHandle));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> deleteMeetingAsync() {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.deleteMeeting(Meeting.this.meetingHandle));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> lockMeetingAsync() {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.lockMeeting(Meeting.this.meetingHandle));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unlockMeetingAsync() {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.unlockMeeting(Meeting.this.meetingHandle));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> muteAllParticipantsAsync() {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.muteAll(Meeting.this.meetingHandle));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unmuteAllParticipantsAsync() {
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.unmuteAll(Meeting.this.meetingHandle));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> muteParticipantAsync(String string) {
        final String string2 = string;
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.muteParticipant(Meeting.this.meetingHandle, string2));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unmuteParticipantAsync(String string) {
        final String string2 = string;
        final Meeting meeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.unmuteParticipant(Meeting.this.meetingHandle, string2));
                    }
                };
                meeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public SafeHandle getImpl() {
        return this.meetingHandle;
    }

    protected void dispose(boolean bl) {
        if (this.disposed) {
            return;
        }
        if (bl) {
            if (this.meetingHandle != null) {
                this.meetingHandle.close();
                this.meetingHandle = null;
            }
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    protected Meeting(long l) {
        this.meetingHandle = new SafeHandle(l, SafeHandleType.Meeting);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.meetingHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncMeetingAction(Runnable runnable) {
        Object object = this.meetingLock;
        synchronized (object) {
            ++this.activeAsyncMeetingCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            runnable.run();
        }
        finally {
            object = this.meetingLock;
            synchronized (object) {
                --this.activeAsyncMeetingCounter;
            }
        }
    }

    private static final native long createMeetingFromConfig(IntRef var0, SafeHandle var1, String var2);

    private final native long getMeetingId(SafeHandle var1, StringRef var2);

    private final native long addParticipant(SafeHandle var1, SafeHandle var2);

    private final native long addParticipantByUser(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipant(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipantByUser(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipantByUserId(SafeHandle var1, String var2);

    private final native long startMeeting(SafeHandle var1);

    private final native long endMeeting(SafeHandle var1);

    private final native long deleteMeeting(SafeHandle var1);

    private final native long lockMeeting(SafeHandle var1);

    private final native long unlockMeeting(SafeHandle var1);

    private final native long muteParticipant(SafeHandle var1, String var2);

    private final native long muteAll(SafeHandle var1);

    private final native long unmuteParticipant(SafeHandle var1, String var2);

    private final native long unmuteAll(SafeHandle var1);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);
}

