/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfile;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class SpeakerVerificationModel
implements AutoCloseable {
    private boolean disposed = false;
    private SafeHandle speakerVerificationModelHandle = null;

    public static SpeakerVerificationModel fromProfile(VoiceProfile voiceProfile) {
        Contracts.throwIfNull(voiceProfile, "profile cannot be null");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SpeakerVerificationModel.createSpeakerVerificationModel(intRef, voiceProfile.getImpl()));
        return new SpeakerVerificationModel(intRef);
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.speakerVerificationModelHandle != null) {
            this.speakerVerificationModelHandle.close();
            this.speakerVerificationModelHandle = null;
        }
        this.disposed = true;
    }

    SpeakerVerificationModel(IntRef intRef) {
        Contracts.throwIfNull(intRef, "modelHandle");
        this.speakerVerificationModelHandle = new SafeHandle(intRef.getValue(), SafeHandleType.SpeakerVerificationModel);
    }

    public SafeHandle getImpl() {
        return this.speakerVerificationModelHandle;
    }

    private static final native long createSpeakerVerificationModel(IntRef var0, SafeHandle var1);

    static {
        Class<?> clazz = SpeechConfig.speechConfigClass;
    }
}

