/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechSynthesisBoundaryType;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SpeechSynthesisWordBoundaryEventArgs {
    private String resultId;
    private long audioOffset;
    private long duration;
    private long textOffset;
    private long wordLength;
    private String text;
    private SpeechSynthesisBoundaryType boundaryType;

    SpeechSynthesisWordBoundaryEventArgs(long l) {
        Contracts.throwIfNull(l, "eventArgs");
        SafeHandle safeHandle = new SafeHandle(l, SafeHandleType.SynthesisEvent);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(safeHandle, stringRef));
        this.resultId = stringRef.getValue();
        IntRef intRef = new IntRef(0L);
        IntRef intRef2 = new IntRef(0L);
        IntRef intRef3 = new IntRef(0L);
        IntRef intRef4 = new IntRef(0L);
        IntRef intRef5 = new IntRef(0L);
        Contracts.throwIfFail(this.getWordBoundaryEventValues(safeHandle, intRef, intRef2, intRef3, intRef4, intRef5));
        this.audioOffset = intRef.getValue();
        this.duration = intRef2.getValue();
        this.textOffset = intRef3.getValue();
        if (this.textOffset > Integer.MAX_VALUE) {
            this.textOffset = -1L;
        }
        this.wordLength = intRef4.getValue();
        this.boundaryType = SpeechSynthesisBoundaryType.values()[(int)intRef5.getValue()];
        this.text = this.getTextFromHandle(safeHandle);
        safeHandle.close();
    }

    public String getResultId() {
        return this.resultId;
    }

    public long getAudioOffset() {
        return this.audioOffset;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getTextOffset() {
        return this.textOffset;
    }

    public long getWordLength() {
        return this.wordLength;
    }

    public String getText() {
        return this.text;
    }

    public SpeechSynthesisBoundaryType getBoundaryType() {
        return this.boundaryType;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getWordBoundaryEventValues(SafeHandle var1, IntRef var2, IntRef var3, IntRef var4, IntRef var5, IntRef var6);

    private final native String getTextFromHandle(SafeHandle var1);
}

