/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.JsonValueJNI;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class JsonValue
implements AutoCloseable {
    private int item;
    private SafeHandle parserHandle;

    public JsonValue(int n, SafeHandle safeHandle) {
        this.item = n;
        this.parserHandle = safeHandle;
    }

    public static JsonValue Parse(String string) {
        return JsonValueJNI.createParser(string);
    }

    public String asString() {
        return JsonValueJNI.asString(this.parserHandle, this.item);
    }

    public long asInt() {
        return JsonValueJNI.asInt(this.parserHandle, this.item);
    }

    public float asFloat() {
        return JsonValueJNI.asFloat(this.parserHandle, this.item);
    }

    public boolean asBoolean() {
        return JsonValueJNI.asBoolean(this.parserHandle, this.item);
    }

    public String asJson() {
        return JsonValueJNI.asJson(this.parserHandle, this.item);
    }

    public JsonValue get(String string) {
        return JsonValueJNI.getValue(this.parserHandle, this.item, 0, string);
    }

    public JsonValue get(int n) {
        return JsonValueJNI.getValue(this.parserHandle, this.item, n, null);
    }

    public String getName(int n) {
        return JsonValueJNI.getName(this.parserHandle, this.item, n, null);
    }

    public boolean hasValue(int n) {
        return JsonValueJNI.hasValue(this.parserHandle, this.item, n, null);
    }

    public boolean hasValue(String string) {
        return JsonValueJNI.hasValue(this.parserHandle, this.item, 0, string);
    }

    public int count() {
        return JsonValueJNI.count(this.parserHandle, this.item);
    }

    @Override
    public void close() throws Exception {
        if (this.parserHandle != null) {
            this.parserHandle.close();
            this.parserHandle = null;
        }
    }
}

