/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.RecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.StringMapRef;
import java.util.HashMap;
import java.util.Map;

public class TranslationRecognitionResult
extends RecognitionResult {
    private Map<String, String> translations;

    public TranslationRecognitionResult(long l) {
        super(l);
        Contracts.throwIfNull(super.getImpl(), "resultHandle");
        StringMapRef stringMapRef = new StringMapRef();
        Contracts.throwIfFail(this.getTranslations(super.getImpl(), stringMapRef));
        this.translations = new HashMap<String, String>();
        if (!stringMapRef.getValue().isEmpty()) {
            this.translations.putAll(stringMapRef.getValue());
        }
    }

    public final Map<String, String> getTranslations() {
        return this.translations;
    }

    public String toString() {
        String string = "ResultId:" + this.getResultId() + " Reason:" + (Object)((Object)this.getReason()) + ", Recognized text:<" + this.getText() + ">.\n";
        for (String string2 : this.translations.keySet()) {
            string = string + "    Translation in " + string2 + ": <" + this.translations.get(string2) + ">.\n";
        }
        return string;
    }

    private final native long getTranslations(SafeHandle var1, StringMapRef var2);
}

