/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.Participant;
import com.microsoft.cognitiveservices.speech.transcription.ParticipantChangedReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.util.ArrayList;
import java.util.List;

public class ConversationParticipantsChangedEventArgs
extends SessionEventArgs {
    private List<Participant> participants;
    private ParticipantChangedReason reason;

    ConversationParticipantsChangedEventArgs(long l) {
        super(l);
        this.storeEventData(l, false);
    }

    ConversationParticipantsChangedEventArgs(long l, boolean bl) {
        super(l);
        this.storeEventData(l, bl);
    }

    public ParticipantChangedReason getReason() {
        return this.reason;
    }

    public List<Participant> getParticipants() {
        return this.participants;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.getSessionId() + " Reason:" + (Object)((Object)this.reason) + " Participants:" + this.participants.size();
    }

    private void storeEventData(long l, boolean bl) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getReason(this.eventHandle, intRef));
        this.reason = ParticipantChangedReason.values()[(int)intRef.getValue()];
        this.participants = new ArrayList<Participant>();
        IntRef intRef2 = new IntRef(0L);
        int n = 0;
        long l2 = this.getParticipantAt(this.eventHandle, n, intRef2);
        while (intRef2.getValue() > 0L) {
            Participant participant = new Participant(intRef2.getValue());
            this.participants.add(participant);
            intRef2 = new IntRef(0L);
            l2 = this.getParticipantAt(this.eventHandle, ++n, intRef2);
        }
        if (bl) {
            super.close();
        }
    }

    private final native long getParticipantAt(SafeHandle var1, int var2, IntRef var3);

    private final native long getReason(SafeHandle var1, IntRef var2);
}

