/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpeechTranslationModel
implements AutoCloseable {
    private String name;
    private List<String> sourceLanguages;
    private List<String> targetLanguages;
    private String path;
    private String version;
    private SafeHandle modelInfoHandle = null;

    SpeechTranslationModel(IntRef intRef) {
        Contracts.throwIfNull(intRef, "modelInfo");
        this.modelInfoHandle = new SafeHandle(intRef.getValue(), SafeHandleType.SpeechTranslationModel);
        this.name = this.getName(this.modelInfoHandle);
        String string = this.getSourceLanguagesString(this.modelInfoHandle);
        this.sourceLanguages = string.isEmpty() ? new ArrayList<String>() : Arrays.asList(string.split("\\|"));
        String string2 = this.getTargetLanguagesString(this.modelInfoHandle);
        this.targetLanguages = string2.isEmpty() ? new ArrayList<String>() : Arrays.asList(string2.split("\\|"));
        this.path = this.getPath(this.modelInfoHandle);
        this.version = this.getVersion(this.modelInfoHandle);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSourceLanguages() {
        return this.sourceLanguages;
    }

    public List<String> getTargetLanguages() {
        return this.targetLanguages;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void close() {
        if (this.modelInfoHandle != null) {
            this.modelInfoHandle.close();
            this.modelInfoHandle = null;
        }
    }

    public SafeHandle getImpl() {
        return this.modelInfoHandle;
    }

    private final native String getName(SafeHandle var1);

    private final native String getSourceLanguagesString(SafeHandle var1);

    private final native String getTargetLanguagesString(SafeHandle var1);

    private final native String getPath(SafeHandle var1);

    private final native String getVersion(SafeHandle var1);
}

