/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.ProfanityOption;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionModel;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisOutputFormat;
import com.microsoft.cognitiveservices.speech.SpeechTranslationModel;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.TelemetryManager;
import java.util.ArrayList;
import java.util.List;

public final class EmbeddedSpeechConfig
implements AutoCloseable {
    SpeechConfig config = null;
    private boolean disposed = false;

    EmbeddedSpeechConfig(long l) {
        this.config = new SpeechConfig(l);
        TelemetryManager.getSingleton();
    }

    public static final EmbeddedSpeechConfig fromPath(String string) {
        Contracts.throwIfNullOrWhitespace(string, "path");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(EmbeddedSpeechConfig.createEmbeddedSpeechConfig(intRef));
        EmbeddedSpeechConfig embeddedSpeechConfig = new EmbeddedSpeechConfig(intRef.getValue());
        Contracts.throwIfFail(EmbeddedSpeechConfig.embeddedSpeechConfigAddPath(embeddedSpeechConfig.config.getImpl(), string));
        return embeddedSpeechConfig;
    }

    public static final EmbeddedSpeechConfig fromPaths(List<String> list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("paths cannot be null or empty");
        }
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(EmbeddedSpeechConfig.createEmbeddedSpeechConfig(intRef));
        EmbeddedSpeechConfig embeddedSpeechConfig = new EmbeddedSpeechConfig(intRef.getValue());
        for (String string : list) {
            Contracts.throwIfFail(EmbeddedSpeechConfig.embeddedSpeechConfigAddPath(embeddedSpeechConfig.config.getImpl(), string));
        }
        return embeddedSpeechConfig;
    }

    public final List<SpeechRecognitionModel> getSpeechRecognitionModels() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getNumSpeechRecognitionModels(this.config.getImpl(), intRef));
        int n = (int)intRef.getValue();
        ArrayList<SpeechRecognitionModel> arrayList = new ArrayList<SpeechRecognitionModel>();
        for (int i = 0; i < n; ++i) {
            IntRef intRef2 = new IntRef(0L);
            Contracts.throwIfFail(this.getSpeechRecognitionModel(this.config.getImpl(), i, intRef2));
            arrayList.add(new SpeechRecognitionModel(intRef2));
        }
        return arrayList;
    }

    public final void setSpeechRecognitionModel(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "name");
        this.config.setProperty(PropertyId.SpeechServiceConnection_RecoModelName, string);
        if (string2 != null && string2.length() != 0) {
            this.config.setProperty(PropertyId.SpeechServiceConnection_RecoModelKey, string2);
        }
    }

    public final String getSpeechRecognitionModelName() {
        return this.config.getProperty(PropertyId.SpeechServiceConnection_RecoModelName);
    }

    public final void setSpeechRecognitionOutputFormat(OutputFormat outputFormat) {
        this.config.setOutputFormat(outputFormat);
    }

    public final OutputFormat getSpeechRecognitionOutputFormat() {
        return this.config.getOutputFormat();
    }

    public final void setProfanity(ProfanityOption profanityOption) {
        this.config.setProfanity(profanityOption);
    }

    public final void setSpeechSynthesisVoice(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "name");
        this.config.setProperty(PropertyId.SpeechServiceConnection_SynthOfflineVoice, string);
        if (string2 != null && string2.length() != 0) {
            this.config.setProperty(PropertyId.SpeechServiceConnection_SynthModelKey, string2);
        }
    }

    public final String getSpeechSynthesisVoiceName() {
        return this.config.getProperty(PropertyId.SpeechServiceConnection_SynthOfflineVoice);
    }

    public final void setSpeechSynthesisOutputFormat(SpeechSynthesisOutputFormat speechSynthesisOutputFormat) {
        this.config.setSpeechSynthesisOutputFormat(speechSynthesisOutputFormat);
    }

    public final String getSpeechSynthesisOutputFormat() {
        return this.config.getSpeechSynthesisOutputFormat();
    }

    public final List<SpeechTranslationModel> getSpeechTranslationModels() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getNumSpeechTranslationModels(this.config.getImpl(), intRef));
        int n = (int)intRef.getValue();
        ArrayList<SpeechTranslationModel> arrayList = new ArrayList<SpeechTranslationModel>();
        for (int i = 0; i < n; ++i) {
            IntRef intRef2 = new IntRef(0L);
            Contracts.throwIfFail(this.getSpeechTranslationModel(this.config.getImpl(), i, intRef2));
            arrayList.add(new SpeechTranslationModel(intRef2));
        }
        return arrayList;
    }

    public final void setSpeechTranslationModel(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "name");
        this.config.setProperty(PropertyId.SpeechTranslation_ModelName, string);
        if (string2 != null && string2.length() != 0) {
            this.config.setProperty(PropertyId.SpeechTranslation_ModelKey, string2);
        }
    }

    public final String getSpeechTranslationModelName() {
        return this.config.getProperty(PropertyId.SpeechTranslation_ModelName);
    }

    public final void setKeywordRecognitionModel(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "name");
        this.config.setProperty(PropertyId.KeywordRecognition_ModelName, string);
        if (string2 != null && string2.length() != 0) {
            this.config.setProperty(PropertyId.KeywordRecognition_ModelKey, string2);
        }
    }

    public final String getKeywordRecognitionModelName() {
        return this.config.getProperty(PropertyId.KeywordRecognition_ModelName);
    }

    public void setProperty(String string, String string2) {
        this.config.setProperty(string, string2);
    }

    public void setProperty(PropertyId propertyId, String string) {
        this.config.setProperty(propertyId, string);
    }

    public String getProperty(String string) {
        return this.config.getProperty(string);
    }

    public String getProperty(PropertyId propertyId) {
        return this.config.getProperty(propertyId);
    }

    @Override
    public final void close() {
        if (this.disposed) {
            return;
        }
        if (this.config != null) {
            this.config.close();
            this.config = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        Contracts.throwIfNull(this.config, "config");
        return this.config.getImpl();
    }

    private static final native long createEmbeddedSpeechConfig(IntRef var0);

    private static final native long embeddedSpeechConfigAddPath(SafeHandle var0, String var1);

    private final native long getNumSpeechRecognitionModels(SafeHandle var1, IntRef var2);

    private final native long getSpeechRecognitionModel(SafeHandle var1, int var2, IntRef var3);

    private final native long getNumSpeechTranslationModels(SafeHandle var1, IntRef var2);

    private final native long getSpeechTranslationModel(SafeHandle var1, int var2, IntRef var3);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

