/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.bot.builder.BotAdapter;
import com.microsoft.bot.builder.BotCallbackHandler;
import com.microsoft.bot.builder.ConnectorClientBuilder;
import com.microsoft.bot.builder.InvokeResponse;
import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.TurnContextImpl;
import com.microsoft.bot.builder.UserTokenProvider;
import com.microsoft.bot.builder.integration.AdapterIntegration;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.ConnectorClient;
import com.microsoft.bot.connector.Conversations;
import com.microsoft.bot.connector.ExecutorFactory;
import com.microsoft.bot.connector.OAuthClient;
import com.microsoft.bot.connector.OAuthClientConfig;
import com.microsoft.bot.connector.authentication.AppCredentials;
import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.JwtTokenValidation;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.connector.authentication.MicrosoftGovernmentAppCredentials;
import com.microsoft.bot.connector.authentication.SimpleCredentialProvider;
import com.microsoft.bot.connector.authentication.SkillValidation;
import com.microsoft.bot.connector.rest.RestConnectorClient;
import com.microsoft.bot.connector.rest.RestOAuthClient;
import com.microsoft.bot.restclient.credentials.ServiceClientCredentials;
import com.microsoft.bot.restclient.retry.RetryStrategy;
import com.microsoft.bot.schema.AadResourceUrls;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationAccount;
import com.microsoft.bot.schema.ConversationParameters;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.ConversationsResult;
import com.microsoft.bot.schema.DeliveryModes;
import com.microsoft.bot.schema.ExpectedReplies;
import com.microsoft.bot.schema.ResourceResponse;
import com.microsoft.bot.schema.Serialization;
import com.microsoft.bot.schema.SignInResource;
import com.microsoft.bot.schema.TokenExchangeRequest;
import com.microsoft.bot.schema.TokenExchangeState;
import com.microsoft.bot.schema.TokenResponse;
import com.microsoft.bot.schema.TokenStatus;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class BotFrameworkAdapter
extends BotAdapter
implements AdapterIntegration,
UserTokenProvider,
ConnectorClientBuilder {
    public static final String INVOKE_RESPONSE_KEY = "BotFrameworkAdapter.InvokeResponse";
    public static final String CONNECTOR_CLIENT_KEY = "ConnectorClient";
    public static final String TEAMSCONNECTOR_CLIENT_KEY = "TeamsConnectorClient";
    private AppCredentials appCredentials;
    private final CredentialProvider credentialProvider;
    private ChannelProvider channelProvider;
    private AuthenticationConfiguration authConfiguration;
    private final RetryStrategy connectorClientRetryStrategy;
    private Map<String, AppCredentials> appCredentialMap = new ConcurrentHashMap<String, AppCredentials>();
    private Map<String, ConnectorClient> connectorClients = new ConcurrentHashMap<String, ConnectorClient>();
    private Map<String, OAuthClient> oAuthClients = new ConcurrentHashMap<String, OAuthClient>();

    public BotFrameworkAdapter(CredentialProvider withCredentialProvider) {
        this(withCredentialProvider, null, null, null);
    }

    public BotFrameworkAdapter(CredentialProvider withCredentialProvider, ChannelProvider withChannelProvider, RetryStrategy withRetryStrategy, Middleware withMiddleware) {
        this(withCredentialProvider, new AuthenticationConfiguration(), withChannelProvider, withRetryStrategy, withMiddleware);
    }

    public BotFrameworkAdapter(CredentialProvider withCredentialProvider, AuthenticationConfiguration withAuthConfig, ChannelProvider withChannelProvider, RetryStrategy withRetryStrategy, Middleware withMiddleware) {
        if (withCredentialProvider == null) {
            throw new IllegalArgumentException("CredentialProvider cannot be null");
        }
        if (withAuthConfig == null) {
            throw new IllegalArgumentException("AuthenticationConfiguration cannot be null");
        }
        this.credentialProvider = withCredentialProvider;
        this.channelProvider = withChannelProvider;
        this.connectorClientRetryStrategy = withRetryStrategy;
        this.authConfiguration = withAuthConfig;
        this.use(new TenantIdWorkaroundForTeamsMiddleware());
        if (withMiddleware != null) {
            this.use(withMiddleware);
        }
    }

    public BotFrameworkAdapter(AppCredentials withCredentials, AuthenticationConfiguration withAuthConfig, ChannelProvider withChannelProvider, RetryStrategy withRetryStrategy, Middleware withMiddleware) {
        if (withCredentials == null) {
            throw new IllegalArgumentException("credentials");
        }
        this.appCredentials = withCredentials;
        this.credentialProvider = new SimpleCredentialProvider(withCredentials.getAppId(), null);
        this.channelProvider = withChannelProvider;
        this.connectorClientRetryStrategy = withRetryStrategy;
        if (withAuthConfig == null) {
            throw new IllegalArgumentException("authConfig");
        }
        this.authConfiguration = withAuthConfig;
        this.use(new TenantIdWorkaroundForTeamsMiddleware());
        if (withMiddleware != null) {
            this.use(withMiddleware);
        }
    }

    @Override
    public CompletableFuture<Void> continueConversation(String botAppId, ConversationReference reference, BotCallbackHandler callback) {
        if (reference == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("reference"));
        }
        if (callback == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("callback"));
        }
        botAppId = botAppId == null ? "" : botAppId;
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("aud", botAppId);
        claims.put("appid", botAppId);
        ClaimsIdentity claimsIdentity = new ClaimsIdentity("ExternalBearer", claims);
        String audience = this.getBotFrameworkOAuthScope();
        return this.continueConversation(claimsIdentity, reference, audience, callback);
    }

    @Override
    public CompletableFuture<Void> continueConversation(ClaimsIdentity claimsIdentity, ConversationReference reference, BotCallbackHandler callback) {
        return this.continueConversation(claimsIdentity, reference, this.getBotFrameworkOAuthScope(), callback);
    }

    @Override
    public CompletableFuture<Void> continueConversation(ClaimsIdentity claimsIdentity, ConversationReference reference, String audience, BotCallbackHandler callback) {
        CompletionStage completionStage;
        if (claimsIdentity == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("claimsIdentity"));
        }
        if (reference == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("reference"));
        }
        if (callback == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("callback"));
        }
        if (StringUtils.isEmpty((CharSequence)audience)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("audience cannot be null or empty"));
        }
        CompletableFuture<Void> pipelineResult = new CompletableFuture<Void>();
        TurnContextImpl context = new TurnContextImpl(this, reference.getContinuationActivity());
        try {
            context.getTurnState().add("BotIdentity", claimsIdentity);
            context.getTurnState().add("Microsoft.Bot.Builder.BotAdapter.OAuthScope", audience);
            completionStage = this.createConnectorClient(reference.getServiceUrl(), claimsIdentity, audience).thenCompose(connectorClient -> {
                context.getTurnState().add(CONNECTOR_CLIENT_KEY, connectorClient);
                return this.runPipeline(context, callback);
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    context.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                pipelineResult.completeExceptionally(e);
                return pipelineResult;
            }
        }
        context.close();
        return completionStage;
    }

    @Override
    public BotFrameworkAdapter use(Middleware middleware) {
        this.getMiddlewareSet().use(middleware);
        return this;
    }

    @Override
    public CompletableFuture<InvokeResponse> processActivity(String authHeader, Activity activity, BotCallbackHandler callback) {
        if (activity == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("Activity"));
        }
        return JwtTokenValidation.authenticateRequest((Activity)activity, (String)authHeader, (CredentialProvider)this.credentialProvider, (ChannelProvider)this.channelProvider, (AuthenticationConfiguration)this.authConfiguration).thenCompose(claimsIdentity -> this.processActivity((ClaimsIdentity)claimsIdentity, activity, callback));
    }

    public CompletableFuture<InvokeResponse> processActivity(ClaimsIdentity identity, Activity activity, BotCallbackHandler callback) {
        if (activity == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("Activity"));
        }
        CompletionStage<InvokeResponse> pipelineResult = new CompletableFuture<InvokeResponse>();
        try (TurnContextImpl context = new TurnContextImpl(this, activity);){
            activity.setCallerId(this.generateCallerId(identity).join());
            context.getTurnState().add("BotIdentity", identity);
            String scope = SkillValidation.isSkillClaim((Map)identity.claims()) != false ? String.format("%s/.default", JwtTokenValidation.getAppIdFromClaims((Map)identity.claims())) : this.getBotFrameworkOAuthScope();
            context.getTurnState().add("Microsoft.Bot.Builder.BotAdapter.OAuthScope", scope);
            pipelineResult = ((CompletableFuture)this.createConnectorClient(activity.getServiceUrl(), identity, scope).thenCompose(connectorClient -> {
                context.getTurnState().add(CONNECTOR_CLIENT_KEY, connectorClient);
                return this.runPipeline(context, callback);
            })).thenCompose(result -> {
                if (DeliveryModes.fromString((String)context.getActivity().getDeliveryMode()) == DeliveryModes.EXPECT_REPLIES) {
                    return CompletableFuture.completedFuture(new InvokeResponse(200, new ExpectedReplies(context.getBufferedReplyActivities())));
                }
                if (activity.isType("invoke")) {
                    Activity invokeResponse = (Activity)context.getTurnState().get(INVOKE_RESPONSE_KEY);
                    if (invokeResponse == null) {
                        return CompletableFuture.completedFuture(new InvokeResponse(501, null));
                    }
                    return CompletableFuture.completedFuture((InvokeResponse)invokeResponse.getValue());
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        catch (Exception e) {
            pipelineResult.completeExceptionally(e);
        }
        return pipelineResult;
    }

    private CompletableFuture<String> generateCallerId(ClaimsIdentity claimsIdentity) {
        return this.credentialProvider.isAuthenticationDisabled().thenApply(is_auth_disabled -> {
            if (is_auth_disabled.booleanValue()) {
                return null;
            }
            if (SkillValidation.isSkillClaim((Map)claimsIdentity.claims()).booleanValue()) {
                return String.format("%s%s", "urn:botframework:aadappid:", JwtTokenValidation.getAppIdFromClaims((Map)claimsIdentity.claims()));
            }
            if (this.channelProvider == null || this.channelProvider.isPublicAzure()) {
                return "urn:botframework:azure";
            }
            if (this.channelProvider != null && this.channelProvider.isGovernment()) {
                return "urn:botframework:azureusgov";
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<ResourceResponse[]> sendActivities(TurnContext context, List<Activity> activities) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("context"));
        }
        if (activities == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("activities"));
        }
        if (activities.size() == 0) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("Expecting one or more activities, but the array was empty."));
        }
        return CompletableFuture.supplyAsync(() -> {
            ResourceResponse[] responses = new ResourceResponse[activities.size()];
            for (int index = 0; index < activities.size(); ++index) {
                ConnectorClient connectorClient;
                ResourceResponse response;
                Activity activity = (Activity)activities.get(index);
                activity.setId(null);
                if (activity.isType("delay")) {
                    int delayMs = (Integer)activity.getValue();
                    try {
                        Thread.sleep(delayMs);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    response = null;
                } else if (activity.isType("invokeResponse")) {
                    context.getTurnState().add(INVOKE_RESPONSE_KEY, activity);
                    response = null;
                } else if (activity.isType("trace") && !StringUtils.equals((CharSequence)activity.getChannelId(), (CharSequence)"emulator")) {
                    response = null;
                } else if (!StringUtils.isEmpty((CharSequence)activity.getReplyToId())) {
                    connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
                    response = (ResourceResponse)connectorClient.getConversations().replyToActivity(activity).join();
                } else {
                    connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
                    response = (ResourceResponse)connectorClient.getConversations().sendToConversation(activity).join();
                }
                if (response == null) {
                    response = new ResourceResponse(activity.getId() == null ? "" : activity.getId());
                }
                responses[index] = response;
            }
            return responses;
        }, ExecutorFactory.getExecutor());
    }

    @Override
    public CompletableFuture<ResourceResponse> updateActivity(TurnContext context, Activity activity) {
        ConnectorClient connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
        return connectorClient.getConversations().updateActivity(activity);
    }

    @Override
    public CompletableFuture<Void> deleteActivity(TurnContext context, ConversationReference reference) {
        ConnectorClient connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
        return connectorClient.getConversations().deleteActivity(reference.getConversation().getId(), reference.getActivityId());
    }

    public CompletableFuture<Void> deleteConversationMember(TurnContextImpl context, String memberId) {
        if (context.getActivity().getConversation() == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("BotFrameworkAdapter.deleteConversationMember(): missing conversation"));
        }
        if (StringUtils.isEmpty((CharSequence)context.getActivity().getConversation().getId())) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("BotFrameworkAdapter.deleteConversationMember(): missing conversation.id"));
        }
        ConnectorClient connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
        String conversationId = context.getActivity().getConversation().getId();
        return connectorClient.getConversations().deleteConversationMember(conversationId, memberId);
    }

    public CompletableFuture<List<ChannelAccount>> getActivityMembers(TurnContextImpl context) {
        return this.getActivityMembers(context, null);
    }

    public CompletableFuture<List<ChannelAccount>> getActivityMembers(TurnContextImpl context, String activityId) {
        if (activityId == null) {
            activityId = context.getActivity().getId();
        }
        if (context.getActivity().getConversation() == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("BotFrameworkAdapter.GetActivityMembers(): missing conversation"));
        }
        if (StringUtils.isEmpty((CharSequence)context.getActivity().getConversation().getId())) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("BotFrameworkAdapter.GetActivityMembers(): missing conversation.id"));
        }
        ConnectorClient connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
        String conversationId = context.getActivity().getConversation().getId();
        return connectorClient.getConversations().getActivityMembers(conversationId, activityId);
    }

    public CompletableFuture<List<ChannelAccount>> getConversationMembers(TurnContextImpl context) {
        if (context.getActivity().getConversation() == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("BotFrameworkAdapter.GetActivityMembers(): missing conversation"));
        }
        if (StringUtils.isEmpty((CharSequence)context.getActivity().getConversation().getId())) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("BotFrameworkAdapter.GetActivityMembers(): missing conversation.id"));
        }
        ConnectorClient connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
        String conversationId = context.getActivity().getConversation().getId();
        return connectorClient.getConversations().getConversationMembers(conversationId);
    }

    public CompletableFuture<ConversationsResult> getConversations(String serviceUrl, MicrosoftAppCredentials credentials) {
        return this.getConversations(serviceUrl, credentials, null);
    }

    public CompletableFuture<ConversationsResult> getConversations(String serviceUrl, MicrosoftAppCredentials credentials, String continuationToken) {
        if (StringUtils.isEmpty((CharSequence)serviceUrl)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("serviceUrl"));
        }
        if (credentials == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("credentials"));
        }
        return this.getOrCreateConnectorClient(serviceUrl, (AppCredentials)credentials).thenCompose(connectorClient -> connectorClient.getConversations().getConversations(continuationToken));
    }

    public CompletableFuture<ConversationsResult> getConversations(TurnContextImpl context) {
        ConnectorClient connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
        return connectorClient.getConversations().getConversations();
    }

    public CompletableFuture<ConversationsResult> getConversations(TurnContextImpl context, String continuationToken) {
        ConnectorClient connectorClient = (ConnectorClient)context.getTurnState().get(CONNECTOR_CLIENT_KEY);
        return connectorClient.getConversations().getConversations(continuationToken);
    }

    @Override
    public CompletableFuture<TokenResponse> getUserToken(TurnContext context, String connectionName, String magicCode) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (context.getActivity().getFrom() == null || StringUtils.isEmpty((CharSequence)context.getActivity().getFrom().getId())) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("BotFrameworkAdapter.getUserToken(): missing from or from.id"));
        }
        if (StringUtils.isEmpty((CharSequence)connectionName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("connectionName"));
        }
        return this.createOAuthAPIClient(context, null).thenCompose(oAuthClient -> oAuthClient.getUserToken().getToken(context.getActivity().getFrom().getId(), connectionName, context.getActivity().getChannelId(), magicCode));
    }

    @Override
    public CompletableFuture<String> getOAuthSignInLink(TurnContext context, String connectionName) {
        return this.getOAuthSignInLink(context, null, connectionName);
    }

    @Override
    public CompletableFuture<String> getOAuthSignInLink(TurnContext context, String connectionName, String userId, String finalRedirect) {
        return this.getOAuthSignInLink(context, null, connectionName, userId, finalRedirect);
    }

    @Override
    public CompletableFuture<Void> signOutUser(TurnContext context, String connectionName, String userId) {
        return this.signOutUser(context, null, connectionName, userId);
    }

    @Override
    public CompletableFuture<List<TokenStatus>> getTokenStatus(TurnContext context, String userId, String includeFilter) {
        return this.getTokenStatus(context, null, userId, includeFilter);
    }

    @Override
    public CompletableFuture<Map<String, TokenResponse>> getAadTokens(TurnContext context, String connectionName, String[] resourceUrls, String userId) {
        return this.getAadTokens(context, null, connectionName, resourceUrls, userId);
    }

    public CompletableFuture<Void> createConversation(String channelId, String serviceUrl, MicrosoftAppCredentials credentials, final ConversationParameters conversationParameters, BotCallbackHandler callback) {
        return this.getOrCreateConnectorClient(serviceUrl, (AppCredentials)credentials).thenCompose(connectorClient -> {
            Conversations conversations = connectorClient.getConversations();
            return conversations.createConversation(conversationParameters).thenCompose(conversationResourceResponse -> {
                Activity eventActivity = Activity.createEventActivity();
                eventActivity.setName("CreateConversation");
                eventActivity.setChannelId(channelId);
                eventActivity.setServiceUrl(serviceUrl);
                eventActivity.setId(conversationResourceResponse.getActivityId() != null ? conversationResourceResponse.getActivityId() : UUID.randomUUID().toString());
                eventActivity.setConversation(new ConversationAccount(conversationResourceResponse.getId()){
                    {
                        super(withId);
                        this.setTenantId(conversationParameters.getTenantId());
                    }
                });
                eventActivity.setChannelData(conversationParameters.getChannelData());
                eventActivity.setRecipient(conversationParameters.getBot());
                CompletableFuture<Object> result = new CompletableFuture();
                try (TurnContextImpl context = new TurnContextImpl(this, eventActivity);){
                    HashMap<String, String> claims = new HashMap<String, String>();
                    claims.put("aud", credentials.getAppId());
                    claims.put("appid", credentials.getAppId());
                    claims.put("serviceurl", serviceUrl);
                    ClaimsIdentity claimsIdentity = new ClaimsIdentity("anonymous", claims);
                    context.getTurnState().add("BotIdentity", claimsIdentity);
                    context.getTurnState().add(CONNECTOR_CLIENT_KEY, connectorClient);
                    result = this.runPipeline(context, callback);
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
                return result;
            });
        });
    }

    @Deprecated
    public CompletableFuture<Void> createConversation(String channelId, String serviceUrl, MicrosoftAppCredentials credentials, ConversationParameters conversationParameters, BotCallbackHandler callback, ConversationReference reference) {
        if (reference.getConversation() == null) {
            return CompletableFuture.completedFuture(null);
        }
        String tenantId = reference.getConversation().getTenantId();
        if (!StringUtils.isEmpty((CharSequence)tenantId)) {
            if (conversationParameters.getChannelData() != null) {
                ((ObjectNode)conversationParameters.getChannelData()).set("tenantId", (JsonNode)JsonNodeFactory.instance.textNode(tenantId));
            } else {
                ObjectNode channelData = JsonNodeFactory.instance.objectNode();
                channelData.set("tenant", JsonNodeFactory.instance.objectNode().set("tenantId", (JsonNode)JsonNodeFactory.instance.textNode(tenantId)));
                conversationParameters.setChannelData((Object)channelData);
            }
            conversationParameters.setTenantId(tenantId);
        }
        return this.createConversation(channelId, serviceUrl, credentials, conversationParameters, callback);
    }

    protected CompletableFuture<OAuthClient> createOAuthAPIClient(TurnContext turnContext, AppCredentials oAuthAppCredentials) {
        if (!OAuthClientConfig.emulateOAuthCards && StringUtils.equalsIgnoreCase((CharSequence)turnContext.getActivity().getChannelId(), (CharSequence)"emulator") && ((Boolean)this.credentialProvider.isAuthenticationDisabled().join()).booleanValue()) {
            OAuthClientConfig.emulateOAuthCards = true;
        }
        AtomicBoolean sendEmulateOAuthCards = new AtomicBoolean(false);
        String appId = this.getBotAppId(turnContext);
        String cacheKey = appId + (oAuthAppCredentials != null ? oAuthAppCredentials.getAppId() : "");
        OAuthClient client = this.oAuthClients.computeIfAbsent(cacheKey, key -> {
            sendEmulateOAuthCards.set(OAuthClientConfig.emulateOAuthCards);
            String oAuthScope = this.getBotFrameworkOAuthScope();
            AppCredentials credentials = oAuthAppCredentials != null ? oAuthAppCredentials : this.getAppCredentials(appId, oAuthScope).join();
            return new RestOAuthClient(OAuthClientConfig.emulateOAuthCards ? turnContext.getActivity().getServiceUrl() : "https://api.botframework.com", (ServiceClientCredentials)credentials);
        });
        if (turnContext.getTurnState().get("OAuthClient") == null) {
            turnContext.getTurnState().add("OAuthClient", client);
        }
        if (sendEmulateOAuthCards.get()) {
            return client.getUserToken().sendEmulateOAuthCards(true).thenApply(voidresult -> client);
        }
        return CompletableFuture.completedFuture(client);
    }

    @Override
    public CompletableFuture<ConnectorClient> createConnectorClient(String serviceUrl, ClaimsIdentity claimsIdentity, String audience) {
        if (claimsIdentity == null) {
            return Async.completeExceptionally((Throwable)new UnsupportedOperationException("ClaimsIdentity cannot be null. Pass Anonymous ClaimsIdentity if authentication is turned off."));
        }
        if (claimsIdentity.claims() == null) {
            return this.getOrCreateConnectorClient(serviceUrl);
        }
        String botAppIdClaim = (String)claimsIdentity.claims().get("aud");
        if (botAppIdClaim == null) {
            botAppIdClaim = (String)claimsIdentity.claims().get("appid");
        }
        if (botAppIdClaim != null) {
            String scope = audience;
            if (StringUtils.isBlank((CharSequence)audience)) {
                scope = SkillValidation.isSkillClaim((Map)claimsIdentity.claims()) != false ? String.format("%s/.default", JwtTokenValidation.getAppIdFromClaims((Map)claimsIdentity.claims())) : this.getBotFrameworkOAuthScope();
            }
            return this.getAppCredentials(botAppIdClaim, scope).thenCompose(credentials -> this.getOrCreateConnectorClient(serviceUrl, (AppCredentials)credentials));
        }
        return this.getOrCreateConnectorClient(serviceUrl);
    }

    private CompletableFuture<ConnectorClient> getOrCreateConnectorClient(String serviceUrl) {
        return this.getOrCreateConnectorClient(serviceUrl, null);
    }

    protected CompletableFuture<ConnectorClient> getOrCreateConnectorClient(String serviceUrl, AppCredentials usingAppCredentials) {
        CompletableFuture<ConnectorClient> result = new CompletableFuture<ConnectorClient>();
        String clientKey = BotFrameworkAdapter.keyForConnectorClient(serviceUrl, usingAppCredentials != null ? usingAppCredentials.getAppId() : null, usingAppCredentials != null ? usingAppCredentials.oAuthScope() : null);
        result.complete(this.connectorClients.computeIfAbsent(clientKey, key -> {
            try {
                RestConnectorClient connectorClient;
                if (usingAppCredentials != null) {
                    connectorClient = new RestConnectorClient(new URI(serviceUrl).toURL().toString(), (ServiceClientCredentials)usingAppCredentials);
                } else {
                    MicrosoftAppCredentials emptyCredentials = this.channelProvider != null && this.channelProvider.isGovernment() ? MicrosoftGovernmentAppCredentials.empty() : MicrosoftAppCredentials.empty();
                    connectorClient = new RestConnectorClient(new URI(serviceUrl).toURL().toString(), (ServiceClientCredentials)emptyCredentials);
                }
                if (this.connectorClientRetryStrategy != null) {
                    connectorClient.setRestRetryStrategy(this.connectorClientRetryStrategy);
                }
                return connectorClient;
            }
            catch (Throwable t) {
                result.completeExceptionally(new IllegalArgumentException(String.format("Invalid Service URL: %s", serviceUrl), t));
                return null;
            }
        }));
        return result;
    }

    private CompletableFuture<AppCredentials> getAppCredentials(String appId, String scope) {
        if (appId == null) {
            return CompletableFuture.completedFuture(MicrosoftAppCredentials.empty());
        }
        String cacheKey = BotFrameworkAdapter.keyForAppCredentials(appId, scope);
        if (this.appCredentialMap.containsKey(cacheKey)) {
            return CompletableFuture.completedFuture(this.appCredentialMap.get(cacheKey));
        }
        if (this.appCredentials != null) {
            this.appCredentialMap.put(cacheKey, this.appCredentials);
            return CompletableFuture.completedFuture(this.appCredentials);
        }
        return this.buildAppCredentials(appId, scope).thenApply(credentials -> {
            this.appCredentialMap.put(cacheKey, (AppCredentials)credentials);
            return credentials;
        });
    }

    protected CompletableFuture<AppCredentials> buildAppCredentials(String appId, String scope) {
        return this.credentialProvider.getAppPassword(appId).thenApply(appPassword -> {
            MicrosoftAppCredentials credentials = this.channelProvider != null && this.channelProvider.isGovernment() ? new MicrosoftGovernmentAppCredentials(appId, appPassword, null, scope) : new MicrosoftAppCredentials(appId, appPassword, null, scope);
            return credentials;
        });
    }

    private String getBotAppId(TurnContext turnContext) throws IllegalStateException {
        ClaimsIdentity botIdentity = (ClaimsIdentity)turnContext.getTurnState().get("BotIdentity");
        if (botIdentity == null) {
            throw new IllegalStateException("An IIdentity is required in TurnState for this operation.");
        }
        String appId = (String)botIdentity.claims().get("aud");
        if (StringUtils.isEmpty((CharSequence)appId)) {
            throw new IllegalStateException("Unable to get the bot AppId from the audience claim.");
        }
        return appId;
    }

    private String getBotFrameworkOAuthScope() {
        return this.channelProvider != null && this.channelProvider.isGovernment() ? "https://api.botframework.us/.default" : "https://api.botframework.com/.default";
    }

    protected static String keyForAppCredentials(String appId, String scope) {
        return appId + (StringUtils.isEmpty((CharSequence)scope) ? "" : scope);
    }

    protected static String keyForConnectorClient(String serviceUrl, String appId, String scope) {
        return serviceUrl + (appId == null ? "" : appId) + (scope == null ? "" : scope);
    }

    protected Map<String, AppCredentials> getCredentialsCache() {
        return Collections.unmodifiableMap(this.appCredentialMap);
    }

    protected Map<String, ConnectorClient> getConnectorClientCache() {
        return Collections.unmodifiableMap(this.connectorClients);
    }

    @Override
    public CompletableFuture<TokenResponse> getUserToken(TurnContext context, AppCredentials oAuthAppCredentials, String connectionName, String magicCode) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (context.getActivity().getFrom() == null || StringUtils.isEmpty((CharSequence)context.getActivity().getFrom().getId())) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("BotFrameworkAdapter.GetUserTokenAsync(): missing from or from.id"));
        }
        if (StringUtils.isEmpty((CharSequence)connectionName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("connectionName cannot be null."));
        }
        return this.createOAuthAPIClient(context, oAuthAppCredentials).thenCompose(client -> client.getUserToken().getToken(context.getActivity().getFrom().getId(), connectionName, context.getActivity().getChannelId(), magicCode));
    }

    @Override
    public CompletableFuture<String> getOAuthSignInLink(TurnContext context, AppCredentials oAuthAppCredentials, String connectionName) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (StringUtils.isEmpty((CharSequence)connectionName)) {
            Async.completeExceptionally((Throwable)new IllegalArgumentException("connectionName cannot be null."));
        }
        return this.createOAuthAPIClient(context, oAuthAppCredentials).thenCompose(oAuthClient -> {
            try {
                Activity activity = context.getActivity();
                String appId = this.getBotAppId(context);
                ConversationReference conversationReference = new ConversationReference();
                conversationReference.setActivityId(activity.getId());
                conversationReference.setBot(activity.getRecipient());
                conversationReference.setChannelId(activity.getChannelId());
                conversationReference.setConversation(activity.getConversation());
                conversationReference.setServiceUrl(activity.getServiceUrl());
                conversationReference.setUser(activity.getFrom());
                TokenExchangeState tokenExchangeState = new TokenExchangeState();
                tokenExchangeState.setConnectionName(connectionName);
                tokenExchangeState.setConversation(conversationReference);
                tokenExchangeState.setRelatesTo(activity.getRelatesTo());
                tokenExchangeState.setMsAppId(appId);
                String serializedState = Serialization.toString((Object)tokenExchangeState);
                String state = Base64.getEncoder().encodeToString(serializedState.getBytes(StandardCharsets.UTF_8));
                return oAuthClient.getBotSignIn().getSignInUrl(state);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        });
    }

    @Override
    public CompletableFuture<String> getOAuthSignInLink(TurnContext context, AppCredentials oAuthAppCredentials, String connectionName, String userId, String finalRedirect) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (StringUtils.isEmpty((CharSequence)connectionName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("connectionName"));
        }
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("userId"));
        }
        return this.createOAuthAPIClient(context, oAuthAppCredentials).thenCompose(oAuthClient -> {
            try {
                Activity activity = context.getActivity();
                String appId = this.getBotAppId(context);
                ConversationReference conversationReference = new ConversationReference();
                conversationReference.setActivityId(activity.getId());
                conversationReference.setBot(activity.getRecipient());
                conversationReference.setChannelId(activity.getChannelId());
                conversationReference.setConversation(activity.getConversation());
                conversationReference.setLocale(activity.getLocale());
                conversationReference.setServiceUrl(activity.getServiceUrl());
                conversationReference.setUser(activity.getFrom());
                TokenExchangeState tokenExchangeState = new TokenExchangeState();
                tokenExchangeState.setConnectionName(connectionName);
                tokenExchangeState.setConversation(conversationReference);
                tokenExchangeState.setRelatesTo(activity.getRelatesTo());
                tokenExchangeState.setMsAppId(appId);
                String serializedState = Serialization.toString((Object)tokenExchangeState);
                String state = Base64.getEncoder().encodeToString(serializedState.getBytes(StandardCharsets.UTF_8));
                return oAuthClient.getBotSignIn().getSignInUrl(state, null, null, finalRedirect);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        });
    }

    @Override
    public CompletableFuture<Void> signOutUser(TurnContext context, AppCredentials oAuthAppCredentials, String connectionName, String userId) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (StringUtils.isEmpty((CharSequence)connectionName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("connectionName"));
        }
        return ((CompletableFuture)this.createOAuthAPIClient(context, oAuthAppCredentials).thenCompose(oAuthClient -> oAuthClient.getUserToken().signOut(context.getActivity().getFrom().getId(), connectionName, context.getActivity().getChannelId()))).thenApply(signOutResult -> null);
    }

    @Override
    public CompletableFuture<List<TokenStatus>> getTokenStatus(TurnContext context, AppCredentials oAuthAppCredentials, String userId, String includeFilter) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("userId"));
        }
        return this.createOAuthAPIClient(context, oAuthAppCredentials).thenCompose(oAuthClient -> oAuthClient.getUserToken().getTokenStatus(userId, context.getActivity().getChannelId(), includeFilter));
    }

    @Override
    public CompletableFuture<Map<String, TokenResponse>> getAadTokens(TurnContext context, AppCredentials oAuthAppCredentials, String connectionName, String[] resourceUrls, String userId) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (StringUtils.isEmpty((CharSequence)connectionName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("connectionName"));
        }
        if (resourceUrls == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("resourceUrls"));
        }
        return this.createOAuthAPIClient(context, oAuthAppCredentials).thenCompose(oAuthClient -> {
            String effectiveUserId = userId;
            if (StringUtils.isEmpty((CharSequence)effectiveUserId) && context.getActivity() != null && context.getActivity().getFrom() != null) {
                effectiveUserId = context.getActivity().getFrom().getId();
            }
            return oAuthClient.getUserToken().getAadTokens(effectiveUserId, connectionName, new AadResourceUrls(resourceUrls));
        });
    }

    @Override
    public CompletableFuture<SignInResource> getSignInResource(TurnContext turnContext, String connectionName) {
        return this.getSignInResource(turnContext, connectionName, turnContext.getActivity().getFrom().getId(), null);
    }

    @Override
    public CompletableFuture<SignInResource> getSignInResource(TurnContext turnContext, String connectionName, String userId, String finalRedirect) {
        return this.getSignInResource(turnContext, null, connectionName, userId, finalRedirect);
    }

    @Override
    public CompletableFuture<SignInResource> getSignInResource(TurnContext context, AppCredentials oAuthAppCredentials, String connectionName, String userId, String finalRedirect) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        if (StringUtils.isEmpty((CharSequence)connectionName)) {
            throw new IllegalArgumentException("connectionName cannot be null.");
        }
        if (StringUtils.isEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("userId cannot be null.");
        }
        return this.createOAuthAPIClient(context, oAuthAppCredentials).thenCompose(oAuthClient -> {
            try {
                Activity activity = context.getActivity();
                String appId = this.getBotAppId(context);
                ConversationReference conversationReference = new ConversationReference();
                conversationReference.setActivityId(activity.getId());
                conversationReference.setBot(activity.getRecipient());
                conversationReference.setChannelId(activity.getChannelId());
                conversationReference.setConversation(activity.getConversation());
                conversationReference.setLocale(activity.getLocale());
                conversationReference.setServiceUrl(activity.getServiceUrl());
                conversationReference.setUser(activity.getFrom());
                TokenExchangeState tokenExchangeState = new TokenExchangeState();
                tokenExchangeState.setConnectionName(connectionName);
                tokenExchangeState.setConversation(conversationReference);
                tokenExchangeState.setRelatesTo(activity.getRelatesTo());
                tokenExchangeState.setMsAppId(appId);
                String serializedState = Serialization.toString((Object)tokenExchangeState);
                String state = Base64.getEncoder().encodeToString(serializedState.getBytes(StandardCharsets.UTF_8));
                return oAuthClient.getBotSignIn().getSignInResource(state, null, null, finalRedirect);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        });
    }

    @Override
    public CompletableFuture<TokenResponse> exchangeToken(TurnContext turnContext, String connectionName, String userId, TokenExchangeRequest exchangeRequest) {
        return this.exchangeToken(turnContext, null, connectionName, userId, exchangeRequest);
    }

    @Override
    public CompletableFuture<TokenResponse> exchangeToken(TurnContext turnContext, AppCredentials oAuthAppCredentials, String connectionName, String userId, TokenExchangeRequest exchangeRequest) {
        if (StringUtils.isEmpty((CharSequence)connectionName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("connectionName is null or empty"));
        }
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("userId is null or empty"));
        }
        if (exchangeRequest == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("exchangeRequest is null"));
        }
        if (StringUtils.isEmpty((CharSequence)exchangeRequest.getToken()) && StringUtils.isEmpty((CharSequence)exchangeRequest.getUri())) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("Either a Token or Uri property is required on the TokenExchangeRequest"));
        }
        return this.createOAuthAPIClient(turnContext, oAuthAppCredentials).thenCompose(oAuthClient -> oAuthClient.getUserToken().exchangeToken(userId, connectionName, turnContext.getActivity().getChannelId(), exchangeRequest));
    }

    protected void addConnectorClientToCache(String serviceUrl, String appId, String scope, ConnectorClient client) {
        String key = BotFrameworkAdapter.keyForConnectorClient(serviceUrl, appId, scope);
        this.connectorClients.put(key, client);
    }

    private static class TenantIdWorkaroundForTeamsMiddleware
    implements Middleware {
        private TenantIdWorkaroundForTeamsMiddleware() {
        }

        @Override
        public CompletableFuture<Void> onTurn(TurnContext turnContext, NextDelegate next) {
            ObjectMapper mapper;
            JsonNode teamsChannelData;
            if (StringUtils.equalsIgnoreCase((CharSequence)turnContext.getActivity().getChannelId(), (CharSequence)"msteams") && turnContext.getActivity().getConversation() != null && StringUtils.isEmpty((CharSequence)turnContext.getActivity().getConversation().getTenantId()) && (teamsChannelData = (mapper = new ObjectMapper().findAndRegisterModules()).valueToTree(turnContext.getActivity().getChannelData())) != null && teamsChannelData.has("tenant") && teamsChannelData.get("tenant").has("id")) {
                turnContext.getActivity().getConversation().setTenantId(teamsChannelData.get("tenant").get("id").asText());
            }
            return next.next();
        }
    }
}

