/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.query;

import com.microsoft.azure.spring.data.cosmosdb.core.ReactiveCosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;

public interface ReactiveCosmosQueryExecution {
    public Object execute(DocumentQuery var1, Class<?> var2, String var3);

    public static final class DeleteExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public DeleteExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String container) {
            return this.operations.delete(query, type, container);
        }
    }

    public static final class ExistsExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public ExistsExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String container) {
            return this.operations.exists(query, type, container);
        }
    }

    public static final class MultiEntityExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public MultiEntityExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String container) {
            return this.operations.find(query, type, container);
        }
    }

    public static final class ContainerExecution
    implements ReactiveCosmosQueryExecution {
        private final ReactiveCosmosOperations operations;

        public ContainerExecution(ReactiveCosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String container) {
            return this.operations.getContainerName(type);
        }
    }
}

