/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.react.mobilecenter;

import android.app.Application;
import com.microsoft.azure.mobile.MobileCenter;
import com.microsoft.azure.mobile.ingestion.models.WrapperSdk;
import java.io.InputStream;
import org.json.JSONObject;

public class RNMobileCenter {
    private static String appSecret;
    private static Application application;
    private static WrapperSdk wrapperSdk;

    public static void configureMobileCenter(Application application) {
        if (MobileCenter.isConfigured()) {
            return;
        }
        RNMobileCenter.application = application;
        wrapperSdk.setWrapperSdkVersion("0.1.1");
        wrapperSdk.setWrapperSdkName("mobilecenter.react-native");
        MobileCenter.setWrapperSdk((WrapperSdk)wrapperSdk);
        MobileCenter.configure((Application)application, (String)RNMobileCenter.getAppSecret());
    }

    public static void setWrapperSdk(WrapperSdk wrapperSdk) {
        RNMobileCenter.wrapperSdk = wrapperSdk;
        MobileCenter.setWrapperSdk((WrapperSdk)wrapperSdk);
    }

    public static WrapperSdk getWrapperSdk() {
        return wrapperSdk;
    }

    public static void setAppSecret(String secret) {
        appSecret = secret;
    }

    public static String getAppSecret() {
        if (appSecret == null) {
            try {
                InputStream configStream = application.getAssets().open("mobile-center-config.json");
                int size = configStream.available();
                byte[] buffer = new byte[size];
                configStream.read(buffer);
                configStream.close();
                String jsonContents = new String(buffer, "UTF-8");
                JSONObject json = new JSONObject(jsonContents);
                appSecret = json.getString("app_secret");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return appSecret;
    }

    public static void setEnabled(boolean enabled) {
        MobileCenter.setEnabled((boolean)enabled);
    }

    public static void setLogLevel(int logLevel) {
        MobileCenter.setLogLevel((int)logLevel);
    }

    public static int getLogLevel() {
        return MobileCenter.getLogLevel();
    }

    static {
        wrapperSdk = new WrapperSdk();
    }
}

