/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.analytics.channel;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import com.microsoft.azure.mobile.analytics.ingestion.models.StartSessionLog;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.UUIDUtils;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;

public class SessionTracker
implements Channel.Listener {
    private static final String STORAGE_KEY = "sessions";
    private static final int STORAGE_MAX_SESSIONS = 5;
    private static final String STORAGE_KEY_VALUE_SEPARATOR = "/";
    private static final long SESSION_TIMEOUT = 20000L;
    private final Channel mChannel;
    private final String mGroupName;
    private final NavigableMap<Long, UUID> mSessions = new TreeMap<Long, UUID>();
    private UUID mSid;
    private long mLastQueuedLogTime;
    private Long mLastResumedTime;
    private Long mLastPausedTime;

    public SessionTracker(Channel channel, String groupName) {
        this.mChannel = channel;
        this.mGroupName = groupName;
        Set storedSessions = StorageHelper.PreferencesStorage.getStringSet((String)STORAGE_KEY);
        if (storedSessions != null) {
            for (String session : storedSessions) {
                String[] split = session.split(STORAGE_KEY_VALUE_SEPARATOR);
                try {
                    Long time = Long.parseLong(split[0]);
                    UUID sid = UUID.fromString(split[1]);
                    this.mSessions.put(time, sid);
                }
                catch (RuntimeException e) {
                    MobileCenterLog.warn((String)"MobileCenterAnalytics", (String)("Ignore invalid session in store: " + session), (Throwable)e);
                }
            }
        }
        MobileCenterLog.debug((String)"MobileCenterAnalytics", (String)("Loaded stored sessions: " + this.mSessions));
    }

    public synchronized void onEnqueuingLog(@NonNull Log log, @NonNull String groupName) {
        Map.Entry<Long, UUID> pastSession;
        if (log instanceof StartSessionLog) {
            return;
        }
        if (log.getToffset() > 0L && (pastSession = this.mSessions.lowerEntry(log.getToffset())) != null) {
            log.setSid(pastSession.getValue());
        }
        if (log.getSid() == null) {
            this.sendStartSessionIfNeeded();
            log.setSid(this.mSid);
            this.mLastQueuedLogTime = SystemClock.elapsedRealtime();
        }
    }

    private void sendStartSessionIfNeeded() {
        if (this.mSid == null || this.hasSessionTimedOut()) {
            this.mSid = UUIDUtils.randomUUID();
            this.mSessions.put(System.currentTimeMillis(), this.mSid);
            if (this.mSessions.size() > 5) {
                this.mSessions.pollFirstEntry();
            }
            HashSet<String> sessionStorage = new HashSet<String>();
            for (Map.Entry session : this.mSessions.entrySet()) {
                sessionStorage.add(session.getKey() + STORAGE_KEY_VALUE_SEPARATOR + session.getValue());
            }
            StorageHelper.PreferencesStorage.putStringSet((String)STORAGE_KEY, sessionStorage);
            StartSessionLog startSessionLog = new StartSessionLog();
            startSessionLog.setSid(this.mSid);
            this.mChannel.enqueue((Log)startSessionLog, this.mGroupName);
        }
    }

    public synchronized void onActivityResumed() {
        MobileCenterLog.debug((String)"MobileCenterAnalytics", (String)"onActivityResumed");
        this.mLastResumedTime = SystemClock.elapsedRealtime();
        this.sendStartSessionIfNeeded();
    }

    public synchronized void onActivityPaused() {
        MobileCenterLog.debug((String)"MobileCenterAnalytics", (String)"onActivityPaused");
        this.mLastPausedTime = SystemClock.elapsedRealtime();
    }

    public synchronized void clearSessions() {
        StorageHelper.PreferencesStorage.remove((String)STORAGE_KEY);
    }

    private boolean hasSessionTimedOut() {
        boolean noLogSentForLong;
        long now = SystemClock.elapsedRealtime();
        boolean bl = noLogSentForLong = now - this.mLastQueuedLogTime >= 20000L;
        if (this.mLastPausedTime == null) {
            return this.mLastResumedTime == null && noLogSentForLong;
        }
        if (this.mLastResumedTime == null) {
            return noLogSentForLong;
        }
        boolean isBackgroundForLong = this.mLastPausedTime >= this.mLastResumedTime && now - this.mLastPausedTime >= 20000L;
        boolean wasBackgroundForLong = this.mLastResumedTime - Math.max(this.mLastPausedTime, this.mLastQueuedLogTime) >= 20000L;
        MobileCenterLog.debug((String)"MobileCenterAnalytics", (String)("noLogSentForLong=" + noLogSentForLong + " isBackgroundForLong=" + isBackgroundForLong + " wasBackgroundForLong=" + wasBackgroundForLong));
        return noLogSentForLong && (isBackgroundForLong || wasBackgroundForLong);
    }
}

