/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.maven.shared.utils.io.DirectoryScanner;

public class Utils {
    private static final String CREATE_TEMP_FILE_FAIL = "Failed to create temp file %s.%s";
    private static final String NO_RESOURCES_CONFIG = "<resources> is empty. Please make sure it is configured in pom.xml.";

    public static File createTempFile(String prefix, String suffix) throws AzureExecutionException {
        try {
            File zipFile = File.createTempFile(prefix, suffix);
            zipFile.deleteOnExit();
            return zipFile;
        }
        catch (IOException e) {
            throw new AzureExecutionException(String.format(CREATE_TEMP_FILE_FAIL, prefix, suffix), e.getCause());
        }
    }

    public static List<File> getArtifacts(Resource resource) {
        ArrayList<File> result = new ArrayList<File>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            directoryScanner.setBasedir(resource.getDirectory());
            directoryScanner.setIncludes(resource.getIncludes().toArray(new String[0]));
            String[] exclude = resource.getExcludes() == null ? new String[]{} : resource.getExcludes().toArray(new String[0]);
            directoryScanner.setExcludes(exclude);
            directoryScanner.scan();
            List resourceFiles = Arrays.stream(directoryScanner.getIncludedFiles()).map(path -> new File(resource.getDirectory(), (String)path)).collect(Collectors.toList());
            result.addAll(resourceFiles);
        }
        return result;
    }

    public static void prepareResources(MavenProject project, MavenSession session, MavenResourcesFiltering filtering, List<Resource> resources, String stagingDirectoryPath) throws IOException, AzureExecutionException {
        if (resources == null || resources.isEmpty()) {
            throw new AzureExecutionException(NO_RESOURCES_CONFIG);
        }
        Utils.copyResources(project, session, filtering, resources, stagingDirectoryPath);
    }

    private static void copyResources(MavenProject project, MavenSession session, MavenResourcesFiltering filtering, List<Resource> resources, String targetDirectory) throws IOException {
        for (Resource resource : resources) {
            String targetPath = resource.getTargetPath() == null ? "" : resource.getTargetPath();
            resource.setTargetPath(Paths.get(targetDirectory, targetPath).toString());
            resource.setFiltering(false);
        }
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, new File(targetDirectory), project, "UTF-8", null, Collections.emptyList(), session);
        mavenResourcesExecution.setEscapeWindowsPaths(true);
        mavenResourcesExecution.setInjectProjectBuildFilters(false);
        mavenResourcesExecution.setOverwrite(true);
        mavenResourcesExecution.setIncludeEmptyDirs(false);
        mavenResourcesExecution.setSupportMultiLineFiltering(false);
        try {
            filtering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException ex) {
            throw new IOException("Failed to copy resources", ex);
        }
    }

    public static String findStringInCollectionIgnoreCase(Collection<String> strs, String find) {
        if (Objects.isNull(strs) || Objects.isNull(find)) {
            return null;
        }
        return strs.stream().filter(str -> StringUtils.equalsIgnoreCase((CharSequence)str, (CharSequence)find)).findFirst().orElse(null);
    }

    private Utils() {
    }
}

