/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.models;

import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class WebAppOption
implements Comparable<WebAppOption> {
    private WebApp webappInner;
    private boolean createNewPlaceHolder = false;

    public WebAppOption(@Nonnull WebApp webapp) {
        this.webappInner = webapp;
    }

    public String getId() {
        return this.webappInner == null ? null : this.webappInner.id();
    }

    public String toString() {
        return this.webappInner != null ? String.format("%s (%s)", this.webappInner.name(), this.getDescription()) : null;
    }

    @Override
    public int compareTo(WebAppOption other) {
        int typeCompareResult = Boolean.compare(this.createNewPlaceHolder, other.isCreateNew());
        if (typeCompareResult != 0) {
            return typeCompareResult;
        }
        String name1 = this.toString();
        String name2 = other.webappInner != null ? other.toString() : null;
        return StringUtils.compare((String)name1, (String)name2);
    }

    private WebAppOption() {
        this.createNewPlaceHolder = true;
    }

    public boolean isCreateNew() {
        return this.createNewPlaceHolder;
    }

    public String getServicePlanId() {
        if (this.webappInner == null) {
            return null;
        }
        return this.webappInner.getAppServicePlan().getId();
    }

    public boolean isDockerWebapp() {
        return this.webappInner != null && this.webappInner.getRuntime().isDocker();
    }

    public boolean isJavaWebApp() {
        return ObjectUtils.notEqual((Object)this.getJavaVersion(), (Object)JavaVersion.OFF);
    }

    public boolean isJavaSE() {
        if (this.webappInner == null) {
            return false;
        }
        if (!this.isJavaWebApp() || this.isDockerWebapp()) {
            return false;
        }
        return Objects.equals(this.webappInner.getRuntime().getWebContainer(), WebContainer.JAVA_SE);
    }

    public JavaVersion getJavaVersion() {
        if (this.webappInner == null || this.webappInner.getRuntime() == null) {
            return JavaVersion.OFF;
        }
        return (JavaVersion)ObjectUtils.firstNonNull((Object[])new JavaVersion[]{this.webappInner.getRuntime().getJavaVersion(), JavaVersion.OFF});
    }

    public OperatingSystem getOperatingSystem() {
        if (this.webappInner == null) {
            return null;
        }
        return this.webappInner.getRuntime().getOperatingSystem();
    }

    public String getDescription() {
        if (this.webappInner == null || this.webappInner.getRuntime() == null) {
            return "unknown";
        }
        return Objects.toString(this.webappInner.getRuntime(), null);
    }

    public WebApp getWebappInner() {
        return this.webappInner;
    }
}

