/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.maven.utils.PomUtils;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.serializer.ConfigurationSerializer;
import com.microsoft.azure.maven.webapp.serializer.V2ConfigurationSerializer;
import com.microsoft.azure.maven.webapp.utils.XMLUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WebAppPomHandler {
    public static final String PLUGIN_GROUP_ID = "com.microsoft.azure";
    public static final String PLUGIN_ARTIFACT_ID = "azure-webapp-maven-plugin";
    final File file;
    final Document document;

    public WebAppPomHandler(String fileName) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.file = new File(fileName);
        this.document = reader.read(this.file);
    }

    public Element getConfiguration() {
        Element mavenPlugin = this.getMavenPluginElement();
        return mavenPlugin == null ? null : mavenPlugin.element("configuration");
    }

    public void updatePluginConfiguration(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs, MavenProject project, PluginDescriptor plugin) throws IOException, MojoFailureException, DocumentException {
        File pom = project.getFile();
        Element pluginNode = PomUtils.getPluginNode((PluginDescriptor)plugin, (File)pom);
        Element configNode = PomUtils.getOrCreateNode((Element)pluginNode, (String[])new String[]{"configuration"});
        V2ConfigurationSerializer serializer = new V2ConfigurationSerializer(newConfigs, oldConfigs);
        ((ConfigurationSerializer)serializer).saveToXML(configNode);
        XMLUtils.setNamespace(pluginNode, pluginNode.getNamespace());
        while (!(configNode.getParent() instanceof PomUtils.LocationAwareElement)) {
            configNode = configNode.getParent();
        }
        FileUtils.fileWrite((File)pom, (String)PomUtils.formatNode((String)FileUtils.fileRead((File)pom), (PomUtils.LocationAwareElement)((PomUtils.LocationAwareElement)configNode.getParent()), (Element)configNode));
    }

    private Element getMavenPluginElement() {
        try {
            Element pluginsRoot = this.document.getRootElement().element("build").element("plugins");
            for (Element element : pluginsRoot.elements()) {
                String groupId = XMLUtils.getChildValue("groupId", element);
                String artifactId = XMLUtils.getChildValue("artifactId", element);
                if (!PLUGIN_GROUP_ID.equals(groupId) || !PLUGIN_ARTIFACT_ID.equals(artifactId)) continue;
                return element;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }
}

