/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.queryer.MavenPluginQueryer;
import com.microsoft.azure.maven.queryer.QueryFactory;
import com.microsoft.azure.maven.utils.CustomTextIoStringListReader;
import com.microsoft.azure.maven.utils.MavenConfigUtils;
import com.microsoft.azure.maven.utils.TextIOUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.handlers.WebAppPomHandler;
import com.microsoft.azure.maven.webapp.models.WebAppOption;
import com.microsoft.azure.maven.webapp.utils.Utils;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.appservice.webapp.AzureWebApp;
import com.microsoft.azure.toolkit.lib.appservice.webapp.WebApp;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.beryx.textio.GenericInputReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.DocumentException;

@Mojo(name="config")
public class ConfigMojo
extends AbstractWebAppMojo {
    private static final String WEB_CONTAINER = "webContainer";
    private static final String JAVA_VERSION = "javaVersion";
    private static final String COMMON_PROMPT = "Define value for %s [%s]:";
    private static final String PRICING_TIER_PROMPT = "Define value for pricingTier [%s]:";
    private static final String NOT_EMPTY_REGEX = "[\\s\\S]+";
    private static final String BOOLEAN_REGEX = "[YyNn]";
    public static final String SUBSCRIPTION_ID_PATTERN = "[a-fA-F0-9\\-]{30,36}";
    public static final String APP_NAME_PATTERN = "[a-zA-Z0-9\\-]{2,60}";
    public static final String RESOURCE_GROUP_PATTERN = "[a-zA-Z0-9\\.\\_\\-\\(\\)]{1,90}";
    public static final String SLOT_NAME_PATTERN = "[A-Za-z0-9-]{1,60}";
    private static final String CONFIG_ONLY_SUPPORT_V2 = "Config only support V2 schema";
    private static final String CHANGE_OS_WARNING = "The plugin may not work if you change the os of an existing webapp.";
    private static final String CONFIGURATION_NO_RUNTIME = "No runtime configuration, skip it.";
    private static final String SAVING_TO_POM = "Saving configuration to pom.";
    private static final String PRICE_TIER_NOT_AVAIL = "The price tier \"%s\" is not available for current OS or runtime, use \"%s\" instead.";
    private static final String NO_JAVA_WEB_APPS = "There are no Java Web Apps in current subscription, please follow the following steps to create a new one.";
    private static final String LONG_LOADING_HINT = "It may take a few minutes to load all Java Web Apps, please be patient.";
    private static final String[] configTypes;
    private static final String SETTING_REGISTRY_USERNAME = "DOCKER_REGISTRY_SERVER_USERNAME";
    private static final String SERVER_ID_TEMPLATE = "Please add a server in Maven settings.xml related to username: %s and put the serverId here";
    private static final List<String> WEB_APP_PROPERTIES;
    private MavenPluginQueryer queryer;
    private WebAppPomHandler pomHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="user/webapp.config")
    protected void doExecute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (!(com.microsoft.azure.toolkit.lib.common.utils.Utils.isJarPackagingProject((String)this.project.getPackaging()) || com.microsoft.azure.toolkit.lib.common.utils.Utils.isEarPackagingProject((String)this.project.getPackaging()) || com.microsoft.azure.toolkit.lib.common.utils.Utils.isWarPackagingProject((String)this.project.getPackaging()))) {
                throw new UnsupportedOperationException(String.format("The project (%s) with packaging %s is not supported for azure app service.", this.project.getName(), this.project.getPackaging()));
            }
            this.queryer = QueryFactory.getQueryer((Settings)this.settings);
            try {
                WebAppConfiguration configuration;
                this.pomHandler = new WebAppPomHandler(this.project.getFile().getAbsolutePath());
                WebAppConfiguration webAppConfiguration = configuration = this.pomHandler.getConfiguration() == null ? null : this.getWebAppConfiguration();
                if (!this.isV2Configuration(configuration)) {
                    Log.warn((String)CONFIG_ONLY_SUPPORT_V2);
                } else {
                    this.config(configuration);
                }
            }
            catch (IOException | IllegalAccessException | MojoFailureException | DocumentException e) {
                throw new AzureToolkitRuntimeException(e.getMessage(), e);
            }
            finally {
                this.queryer.close();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private boolean isV2Configuration(WebAppConfiguration configuration) {
        return configuration == null || this.schemaVersion.equalsIgnoreCase(SchemaVersion.V2.toString());
    }

    private boolean isProjectConfigured() {
        String pluginIdentifier = this.plugin.getPluginLookupKey();
        Xpp3Dom configuration = MavenConfigUtils.getPluginConfiguration((MavenProject)this.getProject(), (String)pluginIdentifier);
        if (configuration == null) {
            return false;
        }
        for (Xpp3Dom child : configuration.getChildren()) {
            if (!WEB_APP_PROPERTIES.contains(child.getName())) continue;
            return true;
        }
        return false;
    }

    protected void config(WebAppConfiguration configuration) throws MojoFailureException, IOException, IllegalAccessException, DocumentException {
        WebAppConfiguration result;
        do {
            if (configuration == null || !this.isProjectConfigured()) {
                try {
                    String createNewConfiguration = this.queryer.assureInputFromUser("confirm", "Y", BOOLEAN_REGEX, "Create new run configuration (Y/N)", null);
                    if (StringUtils.equalsIgnoreCase((CharSequence)createNewConfiguration, (CharSequence)"Y")) {
                        result = this.initConfig();
                    }
                    result = Optional.ofNullable(this.chooseExistingWebappForConfiguration()).orElseGet(this::initConfig);
                }
                catch (AzureAuthFailureException e) {
                    throw new AzureToolkitRuntimeException(String.format("Cannot get Web App list due to error: %s.", e.getMessage()), (Throwable)e);
                }
            } else {
                result = this.updateConfiguration((WebAppConfiguration)configuration.toBuilder().build());
            }
        } while (!this.confirmConfiguration(result));
        Log.info((String)SAVING_TO_POM);
        this.pomHandler.updatePluginConfiguration(result, configuration, this.project, this.plugin);
    }

    protected boolean confirmConfiguration(WebAppConfiguration configuration) {
        System.out.println("Please confirm webapp properties");
        if (StringUtils.isNotBlank((CharSequence)configuration.getSubscriptionId())) {
            System.out.println("Subscription Id : " + configuration.getSubscriptionId());
        }
        System.out.println("AppName : " + configuration.getAppName());
        System.out.println("ResourceGroup : " + configuration.getResourceGroup());
        System.out.println("Region : " + configuration.getRegion());
        if (configuration.getPricingTier() != null) {
            System.out.println("PricingTier : " + configuration.getPricingTier());
        }
        if (configuration.getOs() == null) {
            System.out.println(CONFIGURATION_NO_RUNTIME);
        } else {
            System.out.println("OS : " + configuration.getOs().toString());
            switch (configuration.getOs()) {
                case WINDOWS: 
                case LINUX: {
                    System.out.println("Java Version: " + configuration.getJavaVersion());
                    System.out.println("Web server stack: " + configuration.getWebContainer());
                    break;
                }
                case DOCKER: {
                    System.out.println("Image : " + configuration.getImage());
                    if (StringUtils.isNotBlank((CharSequence)configuration.getServerId())) {
                        System.out.println("ServerId : " + configuration.getServerId());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)configuration.getRegistryUrl())) break;
                    System.out.println("RegistryUrl : " + configuration.getRegistryUrl());
                    break;
                }
                default: {
                    throw new AzureToolkitRuntimeException("The value of <os> is unknown.");
                }
            }
        }
        System.out.println("Deploy to slot : " + (configuration.getDeploymentSlotSetting() != null));
        if (configuration.getDeploymentSlotSetting() != null) {
            DeploymentSlotSetting slotSetting = configuration.getDeploymentSlotSetting();
            System.out.println("Slot name : " + slotSetting.getName());
            System.out.println("ConfigurationSource : " + slotSetting.getConfigurationSource());
        }
        String result = this.queryer.assureInputFromUser("confirm", "Y", BOOLEAN_REGEX, "Confirm (Y/N)", null);
        return result.equalsIgnoreCase("Y");
    }

    protected WebAppConfiguration initConfig() {
        WebAppConfiguration result = this.getDefaultConfiguration();
        return this.getRuntimeConfiguration(result, true);
    }

    private WebAppConfiguration getDefaultConfiguration() {
        WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = WebAppConfiguration.builder();
        String defaultName = this.getProject().getArtifactId() + "-" + System.currentTimeMillis();
        String resourceGroup = defaultName + "-rg";
        String defaultSchemaVersion = "v2";
        Region defaultRegion = WebAppConfiguration.getDefaultRegion();
        return ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.appName(defaultName)).subscriptionId(this.subscriptionId)).resourceGroup(resourceGroup)).region(defaultRegion)).resources(Deployment.getDefaultDeploymentConfiguration(this.getProject().getPackaging()).getResources())).schemaVersion("v2")).subscriptionId(this.subscriptionId)).build();
    }

    protected WebAppConfiguration updateConfiguration(WebAppConfiguration configuration) {
        String selection;
        switch (selection = this.queryer.assureInputFromUser("selection", configTypes[0], Arrays.asList(configTypes), String.format("Please choose which part to config [%s]:", configTypes[0]))) {
            case "Application": {
                return this.getWebAppConfiguration(configuration);
            }
            case "Runtime": {
                Log.warn((String)CHANGE_OS_WARNING);
                return this.getRuntimeConfiguration(configuration, false);
            }
            case "DeploymentSlot": {
                return this.getSlotConfiguration(configuration);
            }
        }
        throw new AzureToolkitRuntimeException("Unknown webapp setting");
    }

    private WebAppConfiguration getWebAppConfiguration(WebAppConfiguration configuration) {
        WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = configuration.toBuilder();
        String defaultSubscriptionId = StringUtils.isNotBlank((CharSequence)configuration.subscriptionId) ? configuration.subscriptionId : null;
        String subscriptionId = StringUtils.isNotBlank((CharSequence)defaultSubscriptionId) ? this.queryer.assureInputFromUser("subscriptionId", defaultSubscriptionId, SUBSCRIPTION_ID_PATTERN, null, null) : null;
        String defaultAppName = this.getDefaultValue(configuration.appName, this.getProject().getArtifactId(), APP_NAME_PATTERN);
        String appName = this.queryer.assureInputFromUser("appName", defaultAppName, APP_NAME_PATTERN, null, null);
        String defaultResourceGroup = this.getDefaultValue(configuration.resourceGroup, String.format("%s-rg", appName), RESOURCE_GROUP_PATTERN);
        String resourceGroup = this.queryer.assureInputFromUser("resourceGroup", defaultResourceGroup, RESOURCE_GROUP_PATTERN, null, null);
        String defaultRegion = configuration.getRegionOrDefault();
        String region = this.queryer.assureInputFromUser("region", defaultRegion, NOT_EMPTY_REGEX, null, null);
        boolean isJBoss = ConfigMojo.isJBossRuntime(WebContainer.fromString((String)configuration.getWebContainer()));
        PricingTier defaultPricingTierFromRuntime = isJBoss ? WebAppConfiguration.DEFAULT_JBOSS_PRICING_TIER : WebAppConfiguration.DEFAULT_PRICINGTIER;
        String currentPricingTier = configuration.getPricingTier();
        List<String> availablePriceList = ConfigMojo.getAvailablePricingTierList(configuration.getOs(), WebContainer.fromString((String)configuration.getWebContainer()));
        String defaultPricingTier = currentPricingTier;
        if (availablePriceList.stream().noneMatch(price -> StringUtils.equalsIgnoreCase((CharSequence)price, (CharSequence)currentPricingTier))) {
            defaultPricingTier = defaultPricingTierFromRuntime.toString();
            if (StringUtils.isNotBlank((CharSequence)currentPricingTier)) {
                Log.warn((String)String.format(PRICE_TIER_NOT_AVAIL, currentPricingTier, defaultPricingTier));
            }
        }
        String pricingTier = this.queryer.assureInputFromUser("pricingTier", defaultPricingTier, availablePriceList, String.format(PRICING_TIER_PROMPT, defaultPricingTier));
        return ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.subscriptionId(subscriptionId)).appName(appName)).resourceGroup(resourceGroup)).region(Region.fromName((String)region))).pricingTier(pricingTier)).build();
    }

    private static boolean isJBossRuntime(WebContainer runtimeStack) {
        return runtimeStack != null && StringUtils.startsWithIgnoreCase((CharSequence)runtimeStack.getValue(), (CharSequence)"JBOSSEAP");
    }

    private WebAppConfiguration getSlotConfiguration(WebAppConfiguration configuration) {
        WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = configuration.toBuilder();
        DeploymentSlotSetting deploymentSlotSetting = configuration.getDeploymentSlotSetting();
        String defaultIsSlotDeploy = deploymentSlotSetting == null ? "N" : "Y";
        String isSlotDeploy = this.queryer.assureInputFromUser("isSlotDeploy", defaultIsSlotDeploy, BOOLEAN_REGEX, "Deploy to slot?(Y/N)", null);
        if (StringUtils.equalsIgnoreCase((CharSequence)isSlotDeploy, (CharSequence)"n")) {
            return ((WebAppConfiguration.WebAppConfigurationBuilder)builder.deploymentSlotSetting(null)).build();
        }
        String defaultSlotName = deploymentSlotSetting == null ? String.format("%s-slot", configuration.getAppName()) : deploymentSlotSetting.getName();
        String slotName = this.queryer.assureInputFromUser("slotName", defaultSlotName, SLOT_NAME_PATTERN, null, null);
        String defaultConfigurationSource = deploymentSlotSetting == null ? null : deploymentSlotSetting.getConfigurationSource();
        String configurationSource = this.queryer.assureInputFromUser("configurationSource", defaultConfigurationSource, null, null, null);
        DeploymentSlotSetting result = new DeploymentSlotSetting();
        result.setName(slotName);
        result.setConfigurationSource(configurationSource);
        return ((WebAppConfiguration.WebAppConfigurationBuilder)builder.deploymentSlotSetting(result)).build();
    }

    private WebAppConfiguration getRuntimeConfiguration(WebAppConfiguration configuration, boolean initial) {
        WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = configuration.toBuilder();
        OperatingSystem defaultOs = (OperatingSystem)ObjectUtils.defaultIfNull((Object)configuration.getOs(), (Object)OperatingSystem.LINUX);
        String os = this.queryer.assureInputFromUser("OS", (Enum)defaultOs, String.format("Define value for OS [%s]:", defaultOs));
        OperatingSystem osEnu = OperatingSystem.fromString((String)os);
        WebContainer webContainer = null;
        builder.os(osEnu);
        switch (osEnu) {
            case WINDOWS: 
            case LINUX: {
                webContainer = this.getRuntimeConfigurationForWindowsOrLinux(osEnu, builder, configuration);
                break;
            }
            case DOCKER: {
                builder = this.getRuntimeConfigurationOfDocker(builder, configuration);
                break;
            }
            default: {
                throw new AzureToolkitRuntimeException("The value of <os> is unknown.");
            }
        }
        boolean isJBoss = ConfigMojo.isJBossRuntime(webContainer);
        if (initial || ConfigMojo.pricingTierNotSupport(osEnu, configuration.getPricingTier(), webContainer)) {
            PricingTier defaultPricingTierEnu = isJBoss ? WebAppConfiguration.DEFAULT_JBOSS_PRICING_TIER : WebAppConfiguration.DEFAULT_PRICINGTIER;
            String defaultPricingTier = (String)ObjectUtils.firstNonNull((Object[])new String[]{configuration.getPricingTier(), defaultPricingTierEnu.getSize()});
            List<String> availablePriceList = ConfigMojo.getAvailablePricingTierList(osEnu, webContainer);
            if (!availablePriceList.contains(defaultPricingTier)) {
                Log.warn((String)String.format("'%s' is not supported in current os('%s') and runtime('%s')", defaultPricingTier, os, webContainer));
                defaultPricingTier = defaultPricingTierEnu.getSize();
            }
            String pricingTier = this.queryer.assureInputFromUser("pricingTier", defaultPricingTier, availablePriceList, String.format(PRICING_TIER_PROMPT, defaultPricingTier));
            builder.pricingTier(pricingTier);
        }
        return builder.build();
    }

    private static boolean pricingTierNotSupport(@Nonnull OperatingSystem parseOperationSystem, String pricingTier, WebContainer webContainer) {
        if (StringUtils.isBlank((CharSequence)pricingTier)) {
            return false;
        }
        PricingTier pricingTierEnum = PricingTier.fromString((String)pricingTier);
        if (pricingTierEnum == null) {
            return true;
        }
        List<String> availablePriceList = ConfigMojo.getAvailablePricingTierList(parseOperationSystem, webContainer);
        return Objects.isNull(Utils.findStringInCollectionIgnoreCase(availablePriceList, pricingTierEnum.getSize()));
    }

    private WebContainer getRuntimeConfigurationForWindowsOrLinux(OperatingSystem os, WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder, WebAppConfiguration configuration) {
        String javaVersionInput;
        JavaVersion javaVersion;
        String defaultJavaVersion = Objects.toString(configuration.getJavaVersionOrDefault());
        List<String> validJavaVersions = ConfigMojo.getValidJavaVersions();
        if (!validJavaVersions.contains(defaultJavaVersion)) {
            Log.warn((String)String.format("'%s' is not supported.", defaultJavaVersion));
            defaultJavaVersion = WebAppConfiguration.DEFAULT_JAVA_VERSION.toString();
        }
        if ((javaVersion = JavaVersion.fromString((String)(javaVersionInput = this.queryer.assureInputFromUser(JAVA_VERSION, defaultJavaVersion, validJavaVersions, String.format(COMMON_PROMPT, JAVA_VERSION, defaultJavaVersion))))) == null) {
            throw new AzureToolkitRuntimeException(String.format("Cannot handle java version: '%s'", javaVersionInput));
        }
        if (this.isJarProject()) {
            ((WebAppConfiguration.WebAppConfigurationBuilder)builder.javaVersion(javaVersionInput)).webContainer(WebContainer.JAVA_SE.toString());
            return WebContainer.JAVA_SE;
        }
        String webContainerOrDefault = configuration.getWebContainerOrDefault();
        List<String> validWebContainers = ConfigMojo.getAvailableWebContainer(os, javaVersion, com.microsoft.azure.toolkit.lib.common.utils.Utils.isJarPackagingProject((String)this.project.getPackaging()));
        if (!validWebContainers.contains(webContainerOrDefault)) {
            Log.warn((String)String.format("'%s' is not supported.", webContainerOrDefault));
            String defaultWebContainer = WebAppConfiguration.DEFAULT_CONTAINER.toString();
            webContainerOrDefault = validWebContainers.contains(defaultWebContainer) ? defaultWebContainer : validWebContainers.get(0);
        }
        String webContainerInput = this.queryer.assureInputFromUser(WEB_CONTAINER, webContainerOrDefault, validWebContainers, String.format(COMMON_PROMPT, WEB_CONTAINER, webContainerOrDefault));
        ((WebAppConfiguration.WebAppConfigurationBuilder)builder.javaVersion(javaVersion.toString())).webContainer(webContainerInput);
        return WebContainer.fromString((String)webContainerInput);
    }

    private WebAppConfiguration.WebAppConfigurationBuilder<?, ?> getRuntimeConfigurationOfDocker(WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder, WebAppConfiguration configuration) {
        String image = this.queryer.assureInputFromUser("image", configuration.image, NOT_EMPTY_REGEX, null, null);
        String serverId = this.queryer.assureInputFromUser("serverId", configuration.serverId, null, null, null);
        String registryUrl = this.queryer.assureInputFromUser("registryUrl", configuration.registryUrl, null, null, null);
        return ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.image(image)).serverId(serverId)).registryUrl(registryUrl);
    }

    private static List<String> getAvailablePricingTierList(OperatingSystem operatingSystem, WebContainer webContainer) {
        ArrayList<String> pricingTierList = new ArrayList<String>();
        if (ConfigMojo.isJBossRuntime(webContainer)) {
            pricingTierList.add("P1v3");
            pricingTierList.add("P2v3");
            pricingTierList.add("P3v3");
            return pricingTierList;
        }
        List availablePricingTier = AppServiceUtils.getAvailablePricingTiers((OperatingSystem)operatingSystem);
        for (PricingTier pricingTier : availablePricingTier) {
            pricingTierList.add(pricingTier.getSize());
        }
        return pricingTierList.stream().distinct().sorted().collect(Collectors.toList());
    }

    private static List<String> getAvailableWebContainer(@Nonnull OperatingSystem os, @Nonnull JavaVersion javaVersion, boolean isJarPacking) {
        ArrayList<String> result = new ArrayList<String>();
        if (isJarPacking) {
            result.add(WebContainer.JAVA_SE.toString());
        } else {
            for (Runtime runtime : ((AzureWebApp)Azure.az(AzureWebApp.class)).listWebAppRuntimes(os, javaVersion)) {
                result.add(runtime.getWebContainer().toString());
            }
            result.remove(WebContainer.JAVA_SE.toString());
        }
        Collections.sort(result);
        return result;
    }

    public static List<String> getValidJavaVersions() {
        return Stream.of(JavaVersion.JAVA_8, JavaVersion.JAVA_11, JavaVersion.JAVA_17).map(Object::toString).collect(Collectors.toList());
    }

    private String getDefaultValue(String defaultValue, String fallBack, String pattern) {
        return StringUtils.isNotEmpty((CharSequence)defaultValue) && defaultValue.matches(pattern) ? defaultValue : fallBack;
    }

    private boolean isJarProject() {
        return com.microsoft.azure.toolkit.lib.common.utils.Utils.isJarPackagingProject((String)this.project.getPackaging());
    }

    private WebAppConfiguration getWebAppConfiguration() {
        this.validateConfiguration(message -> AzureMessager.getMessager().warning(message.getMessage()), false);
        return this.getConfigParser().getWebAppConfiguration();
    }

    private WebAppConfiguration chooseExistingWebappForConfiguration() throws AzureAuthFailureException {
        try {
            AzureAppService az = this.initAzureAppServiceClient();
            if (Objects.isNull(az)) {
                return null;
            }
            List subscriptions = ((IAzureAccount)Azure.az(IAzureAccount.class)).account().getSelectedSubscriptions();
            Subscription defaultSubs = (Subscription)subscriptions.get(0);
            this.subscriptionId = defaultSubs.getId();
            Log.info((String)LONG_LOADING_HINT);
            List webAppOptionList = az.list().stream().flatMap(m -> m.webApps().list().stream()).map(WebAppOption::new).collect(Collectors.toList());
            if (webAppOptionList.isEmpty()) {
                Log.warn((String)NO_JAVA_WEB_APPS);
                return null;
            }
            boolean isContainer = !com.microsoft.azure.toolkit.lib.common.utils.Utils.isJarPackagingProject((String)this.project.getPackaging());
            boolean isDockerOnly = com.microsoft.azure.toolkit.lib.common.utils.Utils.isPomPackagingProject((String)this.project.getPackaging());
            List<WebAppOption> javaOrDockerWebapps = ((Stream)webAppOptionList.stream().parallel()).filter(app -> app.isJavaWebApp() || app.isDockerWebapp()).filter(app -> ConfigMojo.checkWebAppVisible(isContainer, isDockerOnly, app.isJavaSE(), app.isDockerWebapp())).sorted().collect(Collectors.toList());
            WebAppOption selectedApp = ConfigMojo.selectAzureWebApp(javaOrDockerWebapps, ConfigMojo.getWebAppTypeByPackaging(this.project.getPackaging()), defaultSubs);
            if (selectedApp == null) {
                return null;
            }
            WebApp webapp = selectedApp.getWebappInner();
            WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder = WebAppConfiguration.builder();
            if (!AppServiceUtils.isDockerAppService((AppServiceAppBase)webapp)) {
                builder.resources(Deployment.getDefaultDeploymentConfiguration(this.getProject().getPackaging()).getResources());
            }
            return this.getConfigurationFromExisting(webapp, builder);
        }
        catch (AzureToolkitAuthenticationException ex) {
            this.getLog().warn((CharSequence)String.format("Cannot authenticate due to error: %s, select existing webapp is skipped.", ex.getMessage()));
            return null;
        }
    }

    private static WebAppOption selectAzureWebApp(List<WebAppOption> javaOrDockerWebapps, String webAppType, Subscription targetSubscription) {
        ArrayList<WebAppOption> options = new ArrayList<WebAppOption>();
        if (javaOrDockerWebapps.isEmpty()) {
            Log.warn((String)NO_JAVA_WEB_APPS);
            return null;
        }
        options.addAll(javaOrDockerWebapps);
        return (WebAppOption)((GenericInputReader)new CustomTextIoStringListReader(TextIOUtils::getTextTerminal, null).withCustomPrompt(String.format("Please choose a %sWeb App: ", webAppType)).withNumberedPossibleValues(options)).read(new String[]{String.format("%sWeb Apps in subscription %s:", webAppType, TextUtils.blue((String)targetSubscription.getName()))});
    }

    private WebAppConfiguration getConfigurationFromExisting(WebApp webapp, WebAppConfiguration.WebAppConfigurationBuilder<?, ?> builder) {
        AppServiceConfig appServiceConfig = AppServiceConfigUtils.fromAppService((AppServiceAppBase)webapp, (AppServicePlan)webapp.getAppServicePlan());
        ((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)((WebAppConfiguration.WebAppConfigurationBuilder)builder.appName(appServiceConfig.appName())).resourceGroup(appServiceConfig.resourceGroup())).subscriptionId(appServiceConfig.subscriptionId())).region(appServiceConfig.region());
        builder.os(appServiceConfig.runtime().os());
        if (AppServiceUtils.isDockerAppService((AppServiceAppBase)webapp)) {
            Map settings = webapp.getAppSettings();
            builder.image(appServiceConfig.runtime().image());
            builder.registryUrl(appServiceConfig.runtime().registryUrl());
            String dockerUsernameSetting = (String)settings.get(SETTING_REGISTRY_USERNAME);
            if (StringUtils.isNotBlank((CharSequence)dockerUsernameSetting)) {
                builder.serverId(String.format(SERVER_ID_TEMPLATE, dockerUsernameSetting));
            }
        } else {
            builder.webContainer(Objects.toString(appServiceConfig.runtime().webContainer()));
            builder.javaVersion(Objects.toString(appServiceConfig.runtime().javaVersion()));
        }
        builder.servicePlanName(appServiceConfig.servicePlanName());
        builder.servicePlanResourceGroup(appServiceConfig.servicePlanResourceGroup());
        builder.pricingTier(Objects.toString(appServiceConfig.pricingTier()));
        return builder.build();
    }

    private static boolean checkWebAppVisible(boolean isContainer, boolean isDockerOnly, boolean isJavaSEWebApp, boolean isDockerWebapp) {
        if (isDockerWebapp) {
            return true;
        }
        if (isDockerOnly) {
            return false;
        }
        if (isContainer) {
            return !isJavaSEWebApp;
        }
        return isJavaSEWebApp;
    }

    private static String getWebAppTypeByPackaging(String packaging) {
        boolean isContainer = !com.microsoft.azure.toolkit.lib.common.utils.Utils.isJarPackagingProject((String)packaging);
        boolean isDockerOnly = com.microsoft.azure.toolkit.lib.common.utils.Utils.isPomPackagingProject((String)packaging);
        if (isDockerOnly) {
            return "Docker ";
        }
        if (isContainer) {
            return "";
        }
        return "Java SE ";
    }

    static {
        ConfigMojo.ajc$preClinit();
        configTypes = new String[]{"Application", "Runtime", "DeploymentSlot"};
        WEB_APP_PROPERTIES = Arrays.asList("resourceGroup", "appName", "runtime", "deployment", "region", "appServicePlanResourceGroup", "appServicePlanName", "deploymentSlot");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ConfigMojo.java", ConfigMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.webapp.ConfigMojo", "", "", "", "void"), 100);
    }
}

