/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.maven.appservice.AbstractAppServiceMojo;
import com.microsoft.azure.maven.utils.SystemPropertyUtils;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.MavenRuntimeConfig;
import com.microsoft.azure.maven.webapp.parser.ConfigParser;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.validator.SchemaValidator;
import com.microsoft.azure.toolkit.lib.common.validator.ValidationMessage;
import com.microsoft.azure.toolkit.lib.legacy.appservice.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DockerImageType;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractWebAppMojo
extends AbstractAppServiceMojo {
    public static final String JAVA_VERSION_KEY = "javaVersion";
    public static final String JAVA_WEB_CONTAINER_KEY = "javaWebContainer";
    public static final String DOCKER_IMAGE_TYPE_KEY = "dockerImageType";
    public static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    public static final String PRICING_TIER_KEY = "pricingTier";
    public static final String REGION_KEY = "region";
    public static final String OS_KEY = "os";
    public static final String SCHEMA_VERSION_KEY = "schemaVersion";
    public static final String DEPLOY_TO_SLOT_KEY = "isDeployToSlot";
    public static final String SKIP_CREATE_RESOURCE_KEY = "skipCreateResource";
    public static final String INVALID_PARAMETER_ERROR_MESSAGE = "Invalid values found in configuration, please correct the value with messages below:";
    @JsonProperty
    @Parameter(property="webapp.pricingTier")
    protected String pricingTier;
    @JsonProperty
    @Deprecated
    @Parameter(property="webapp.stopAppDuringDeployment", defaultValue="false")
    protected Boolean stopAppDuringDeployment;
    @JsonProperty
    @Parameter(property="webapp.stopAppDuringDeployment", defaultValue="true")
    protected Boolean restartSite;
    @JsonProperty
    @Parameter(property="webapp.skip", defaultValue="false")
    protected Boolean skip;
    @JsonIgnore
    @Parameter(property="azure.resource.create.skip", defaultValue="false")
    protected Boolean skipAzureResourceCreate;
    @JsonIgnore
    @Parameter(property="skipCreateAzureResource")
    protected Boolean skipCreateAzureResource;
    @JsonProperty
    @Parameter(property="webapp.region")
    protected String region;
    @JsonProperty
    @Deprecated
    @Parameter(property="schemaVersion", defaultValue="v2")
    protected String schemaVersion;
    @JsonProperty
    @Parameter(property="runtime")
    protected MavenRuntimeConfig runtime;
    @JsonProperty
    @Parameter(property="deployment")
    protected Deployment deployment;
    @JsonIgnore
    protected File stagingDirectory;
    @JsonIgnore
    protected AzureAppService az;
    @JsonIgnore
    private boolean isRuntimeInjected = false;
    @JsonIgnore
    protected final ConfigParser configParser = new ConfigParser(this);

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName == null ? "" : this.appName;
    }

    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public boolean isDeployToDeploymentSlot() {
        return this.getDeploymentSlotSetting() != null;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public MavenRuntimeConfig getRuntime() {
        if (!this.isRuntimeInjected) {
            this.setRuntime((MavenRuntimeConfig)SystemPropertyUtils.injectCommandLineParameter((String)"runtime", (Object)this.runtime, MavenRuntimeConfig.class));
            this.isRuntimeInjected = true;
        }
        return this.runtime;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void setRuntime(MavenRuntimeConfig runtime) {
        this.runtime = runtime;
    }

    public Map<String, String> getTelemetryProperties() {
        Map map = super.getTelemetryProperties();
        MavenRuntimeConfig runtimeConfig = this.getRuntime();
        String os = Optional.ofNullable(runtimeConfig).map(MavenRuntimeConfig::getOs).orElse("");
        map.put(SCHEMA_VERSION_KEY, this.schemaVersion);
        map.put(OS_KEY, os);
        if (StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)OperatingSystem.DOCKER.getValue())) {
            String imageType = AppServiceUtils.getDockerImageType((String)runtimeConfig.getImage(), (boolean)StringUtils.isEmpty((CharSequence)runtimeConfig.getServerId()), (String)runtimeConfig.getRegistryUrl()).name();
            map.put(DOCKER_IMAGE_TYPE_KEY, imageType);
        } else {
            map.put(DOCKER_IMAGE_TYPE_KEY, DockerImageType.NONE.toString());
        }
        map.put(PRICING_TIER_KEY, this.pricingTier);
        map.put(REGION_KEY, this.region);
        map.put(JAVA_VERSION_KEY, Optional.ofNullable(runtimeConfig).map(MavenRuntimeConfig::getJavaVersion).orElse(""));
        map.put(JAVA_WEB_CONTAINER_KEY, Optional.ofNullable(runtimeConfig).map(MavenRuntimeConfig::getWebContainer).orElse(""));
        boolean isDeployToSlot = Optional.ofNullable(this.getDeploymentSlotSetting()).map(DeploymentSlotSetting::getName).map(StringUtils::isNotEmpty).orElse(false);
        map.put(DEPLOY_TO_SLOT_KEY, String.valueOf(isDeployToSlot));
        map.put(SKIP_CREATE_RESOURCE_KEY, String.valueOf(this.skipAzureResourceCreate != false || BooleanUtils.isTrue((Boolean)this.skipCreateAzureResource)));
        return map;
    }

    protected void validateConfiguration(Consumer<ValidationMessage> validationMessageConsumer, boolean failOnError) {
        List validate = SchemaValidator.getInstance().validate("WebAppConfiguration", (Object)this, "configuration");
        validate.forEach(message -> validationMessageConsumer.accept((ValidationMessage)message));
        if (CollectionUtils.isNotEmpty((Collection)validate) && failOnError) {
            String errorDetails = validate.stream().map(message -> message.getMessage().toString()).collect(Collectors.joining("\n"));
            throw new AzureToolkitRuntimeException(String.join((CharSequence)"\n", INVALID_PARAMETER_ERROR_MESSAGE, errorDetails));
        }
    }

    public String getSubscriptionId() {
        if (this.appServiceClient == null) {
            return this.subscriptionId;
        }
        List subscriptions = ((IAzureAccount)Azure.az(IAzureAccount.class)).account().getSelectedSubscriptions();
        Subscription subscription = (Subscription)subscriptions.get(0);
        return subscription.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeploymentStagingDirectoryPath() {
        if (this.stagingDirectory == null) {
            AbstractWebAppMojo abstractWebAppMojo = this;
            synchronized (abstractWebAppMojo) {
                if (this.stagingDirectory == null) {
                    String outputFolder = this.getPluginName().replaceAll("-maven-plugin", "");
                    String stagingDirectoryPath = Paths.get(this.getBuildDirectoryAbsolutePath(), outputFolder, String.format("%s-%s", this.getAppName(), UUID.randomUUID().toString())).toString();
                    this.stagingDirectory = new File(stagingDirectoryPath);
                    if (!this.stagingDirectory.exists()) {
                        this.stagingDirectory.mkdirs();
                    }
                }
            }
        }
        return this.stagingDirectory.getPath();
    }

    @Deprecated
    public Boolean getStopAppDuringDeployment() {
        return this.stopAppDuringDeployment;
    }

    public Boolean getRestartSite() {
        return this.restartSite;
    }

    public ConfigParser getConfigParser() {
        return this.configParser;
    }
}

