/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.sql.ReplicationLink;
import com.microsoft.azure.management.sql.ReplicationRole;
import com.microsoft.azure.management.sql.ReplicationState;
import com.microsoft.azure.management.sql.implementation.DatabasesInner;
import com.microsoft.azure.management.sql.implementation.ReplicationLinkInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@LangDefinition
class ReplicationLinkImpl
extends RefreshableWrapperImpl<ReplicationLinkInner, ReplicationLink>
implements ReplicationLink {
    private final DatabasesInner innerCollection;
    private final ResourceId resourceId = ResourceId.fromString((String)((ReplicationLinkInner)this.inner()).id());

    protected ReplicationLinkImpl(ReplicationLinkInner innerObject, DatabasesInner innerCollection) {
        super((Object)innerObject);
        this.innerCollection = innerCollection;
    }

    protected Observable<ReplicationLinkInner> getInnerAsync() {
        return this.innerCollection.getReplicationLinkAsync(this.resourceGroupName(), this.sqlServerName(), this.databaseName(), this.name());
    }

    @Override
    public String sqlServerName() {
        return this.resourceId.parent().parent().name();
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public String partnerServer() {
        return ((ReplicationLinkInner)this.inner()).partnerServer();
    }

    @Override
    public String partnerDatabase() {
        return ((ReplicationLinkInner)this.inner()).partnerDatabase();
    }

    @Override
    public String partnerLocation() {
        return ((ReplicationLinkInner)this.inner()).partnerLocation();
    }

    @Override
    public ReplicationRole role() {
        return ((ReplicationLinkInner)this.inner()).role();
    }

    @Override
    public ReplicationRole partnerRole() {
        return ((ReplicationLinkInner)this.inner()).partnerRole();
    }

    @Override
    public DateTime startTime() {
        return ((ReplicationLinkInner)this.inner()).startTime();
    }

    @Override
    public int percentComplete() {
        return Utils.toPrimitiveInt((Integer)((ReplicationLinkInner)this.inner()).percentComplete());
    }

    @Override
    public ReplicationState replicationState() {
        return ((ReplicationLinkInner)this.inner()).replicationState();
    }

    @Override
    public void delete() {
        this.innerCollection.deleteReplicationLink(this.resourceGroupName(), this.sqlServerName(), this.databaseName(), this.name());
    }

    @Override
    public void failover() {
        this.failoverAsync().await();
    }

    @Override
    public Completable failoverAsync() {
        return this.innerCollection.failoverReplicationLinkAsync(this.resourceGroupName(), this.sqlServerName(), this.databaseName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> failoverAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.failoverAsync().toObservable(), callback);
    }

    @Override
    public void forceFailoverAllowDataLoss() {
        this.forceFailoverAllowDataLossAsync().await();
    }

    @Override
    public Completable forceFailoverAllowDataLossAsync() {
        return this.innerCollection.failoverReplicationLinkAllowDataLossAsync(this.resourceGroupName(), this.sqlServerName(), this.databaseName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> forceFailoverAllowDataLossAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.forceFailoverAllowDataLossAsync().toObservable(), callback);
    }

    public String name() {
        return this.resourceId.name();
    }

    public String id() {
        return this.resourceId.id();
    }

    public String resourceGroupName() {
        return this.resourceId.resourceGroupName();
    }
}

