/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.sql.CreateMode;
import com.microsoft.azure.management.sql.DatabaseEditions;
import com.microsoft.azure.management.sql.DatabaseMetric;
import com.microsoft.azure.management.sql.ReplicationLink;
import com.microsoft.azure.management.sql.RestorePoint;
import com.microsoft.azure.management.sql.ServiceObjectiveName;
import com.microsoft.azure.management.sql.ServiceTierAdvisor;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlWarehouse;
import com.microsoft.azure.management.sql.TransparentDataEncryption;
import com.microsoft.azure.management.sql.UpgradeHintInterface;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;

@Fluent
public interface SqlDatabase
extends IndependentChildResource<SqlServerManager, DatabaseInner>,
Refreshable<SqlDatabase>,
Updatable<Update> {
    public String sqlServerName();

    public String collation();

    public DateTime creationDate();

    public UUID currentServiceObjectiveId();

    public String databaseId();

    public DateTime earliestRestoreDate();

    public DatabaseEditions edition();

    public UUID requestedServiceObjectiveId();

    public long maxSizeBytes();

    public ServiceObjectiveName requestedServiceObjectiveName();

    public ServiceObjectiveName serviceLevelObjective();

    public String status();

    public String elasticPoolName();

    public String defaultSecondaryLocation();

    public UpgradeHintInterface getUpgradeHint();

    public boolean isDataWarehouse();

    @Method
    public SqlWarehouse asWarehouse();

    public List<RestorePoint> listRestorePoints();

    public List<DatabaseMetric> listUsages();

    public TransparentDataEncryption getTransparentDataEncryption();

    public Map<String, ServiceTierAdvisor> listServiceTierAdvisors();

    public Map<String, ReplicationLink> listReplicationLinks();

    public void delete();

    public static interface UpdateStages {

        public static interface WithElasticPoolName {
            public WithEdition withoutElasticPool();

            public Update withExistingElasticPool(String var1);

            public Update withExistingElasticPool(SqlElasticPool var1);

            public Update withNewElasticPool(Creatable<SqlElasticPool> var1);
        }

        public static interface WithServiceObjective {
            public Update withServiceObjective(ServiceObjectiveName var1);
        }

        public static interface WithMaxSizeBytes {
            public Update withMaxSizeBytes(long var1);
        }

        public static interface WithEdition {
            public Update withEdition(DatabaseEditions var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithEdition,
    UpdateStages.WithElasticPoolName,
    UpdateStages.WithMaxSizeBytes,
    UpdateStages.WithServiceObjective,
    Appliable<SqlDatabase> {
    }

    public static interface DefinitionStages {

        public static interface WithCreateWithLessOptions
        extends Creatable<SqlDatabase>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithCreate
        extends WithServiceObjective,
        WithEdition,
        WithCollationAllCreateOptions,
        WithMaxSizeBytesAllCreateOptions,
        WithCreateWithLessOptions {
        }

        public static interface WithServiceObjective {
            public WithCreate withServiceObjective(ServiceObjectiveName var1);
        }

        public static interface WithMaxSizeBytes {
            public WithCreateWithElasticPoolOptions withMaxSizeBytes(long var1);
        }

        public static interface WithMaxSizeBytesAllCreateOptions {
            public WithCreate withMaxSizeBytes(long var1);
        }

        public static interface WithEdition {
            public WithCreate withEdition(DatabaseEditions var1);
        }

        public static interface WithCollation {
            public WithCreateWithElasticPoolOptions withCollation(String var1);
        }

        public static interface WithCollationAllCreateOptions {
            public WithCreate withCollation(String var1);
        }

        public static interface WithCreateWithElasticPoolOptions
        extends WithCollation,
        WithMaxSizeBytes,
        WithCreateWithLessOptions {
        }

        public static interface WithCreateMode {
            public WithCreateWithLessOptions withMode(CreateMode var1);
        }

        public static interface WithSourceDatabaseId {
            public WithCreateMode withSourceDatabase(String var1);

            public WithCreateMode withSourceDatabase(SqlDatabase var1);
        }

        public static interface WithExistingDatabase
        extends WithSourceDatabaseId,
        WithCreateWithElasticPoolOptions {
        }

        public static interface WithElasticPoolName {
            public WithExistingDatabase withExistingElasticPool(String var1);

            public WithExistingDatabase withExistingElasticPool(SqlElasticPool var1);

            public WithExistingDatabase withNewElasticPool(Creatable<SqlElasticPool> var1);
        }

        public static interface WithAllDifferentOptions
        extends WithElasticPoolName,
        WithSourceDatabaseId,
        WithCreate {
        }

        public static interface Blank
        extends WithAllDifferentOptions {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate,
    DefinitionStages.WithSourceDatabaseId,
    DefinitionStages.WithElasticPoolName,
    DefinitionStages.WithCreateMode,
    DefinitionStages.WithCreateWithLessOptions {
    }
}

