/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import org.joda.time.DateTime;
import java.util.UUID;
import com.microsoft.azure.management.sql.CreateMode;
import com.microsoft.azure.management.sql.DatabaseEditions;
import com.microsoft.azure.management.sql.ServiceObjectiveName;
import java.util.List;
import com.microsoft.azure.management.sql.UpgradeHint;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Represents an Azure SQL Database.
 */
@JsonFlatten
public class DatabaseInner extends Resource {
    /**
     * The collation of the Azure SQL database.
     */
    @JsonProperty(value = "properties.collation")
    private String collation;

    /**
     * The creation date of the Azure SQL database (ISO8601 format).
     */
    @JsonProperty(value = "properties.creationDate", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime creationDate;

    /**
     * The containment state of the Azure SQL database.
     */
    @JsonProperty(value = "properties.containmentState", access = JsonProperty.Access.WRITE_ONLY)
    private Long containmentState;

    /**
     * The current Service Level Objective ID of the Azure SQL database. This
     * is the ID of the Service Level Objective that is currently active.
     */
    @JsonProperty(value = "properties.currentServiceObjectiveId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID currentServiceObjectiveId;

    /**
     * The ID of the Azure SQL database.
     */
    @JsonProperty(value = "properties.databaseId", access = JsonProperty.Access.WRITE_ONLY)
    private String databaseId;

    /**
     * The recovery period start date of the Azure SQL database. This records
     * the start date and time when recovery is available for this Azure SQL
     * Database (ISO8601 format).
     */
    @JsonProperty(value = "properties.earliestRestoreDate", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime earliestRestoreDate;

    /**
     * Specifies the type of database to create. Possible values include:
     * 'Copy', 'Default', 'NonReadableSecondary', 'OnlineSecondary',
     * 'PointInTimeRestore', 'Recovery', 'Restore'.
     */
    @JsonProperty(value = "properties.createMode")
    private CreateMode createMode;

    /**
     * Conditional. Specifies the resource ID of the source database. If
     * createMode is not set to Default, then this value must be specified. The
     * name of the source database must be the same. NOTE: Collation, Edition,
     * and MaxSizeBytes must remain the same while the link is active. Values
     * specified for these parameters will be ignored.
     */
    @JsonProperty(value = "properties.sourceDatabaseId")
    private String sourceDatabaseId;

    /**
     * The edition of the Azure SQL database. The DatabaseEditions enumeration
     * contains all the valid editions. Possible values include: 'Web',
     * 'Business', 'Basic', 'Standard', 'Premium', 'Free', 'Stretch',
     * 'DataWarehouse'.
     */
    @JsonProperty(value = "properties.edition")
    private DatabaseEditions edition;

    /**
     * The max size of the Azure SQL database expressed in bytes. Note: Only
     * the following sizes are supported (in addition to limitations being
     * placed on each edition): { 100 MB | 500 MB |1 GB | 5 GB | 10 GB | 20 GB
     * | 30 GB … 150 GB | 200 GB … 500 GB }.
     */
    @JsonProperty(value = "properties.maxSizeBytes")
    private String maxSizeBytes;

    /**
     * The configured Service Level Objective ID of the Azure SQL database.
     * This is the Service Level Objective that is in the process of being
     * applied to the Azure SQL database. Once successfully updated, it will
     * match the value of currentServiceObjectiveId property.
     */
    @JsonProperty(value = "properties.requestedServiceObjectiveId")
    private UUID requestedServiceObjectiveId;

    /**
     * The name of the configured Service Level Objective of the Azure SQL
     * database. This is the Service Level Objective that is in the process of
     * being applied to the Azure SQL database. Once successfully updated, it
     * will match the value of serviceLevelObjective property. Possible values
     * include: 'Basic', 'S0', 'S1', 'S2', 'S3', 'P1', 'P2', 'P3'.
     */
    @JsonProperty(value = "properties.requestedServiceObjectiveName")
    private ServiceObjectiveName requestedServiceObjectiveName;

    /**
     * The current Service Level Objective of the Azure SQL database. Possible
     * values include: 'Basic', 'S0', 'S1', 'S2', 'S3', 'P1', 'P2', 'P3'.
     */
    @JsonProperty(value = "properties.serviceLevelObjective", access = JsonProperty.Access.WRITE_ONLY)
    private ServiceObjectiveName serviceLevelObjective;

    /**
     * The status of the Azure SQL database.
     */
    @JsonProperty(value = "properties.status", access = JsonProperty.Access.WRITE_ONLY)
    private String status;

    /**
     * The name of the Azure SQL Elastic Pool the database is in.
     */
    @JsonProperty(value = "properties.elasticPoolName")
    private String elasticPoolName;

    /**
     * The default secondary region for this database.
     */
    @JsonProperty(value = "properties.defaultSecondaryLocation", access = JsonProperty.Access.WRITE_ONLY)
    private String defaultSecondaryLocation;

    /**
     * The list of service tier advisors for this database. Expanded property.
     */
    @JsonProperty(value = "properties.serviceTierAdvisors", access = JsonProperty.Access.WRITE_ONLY)
    private List<ServiceTierAdvisorInner> serviceTierAdvisors;

    /**
     * The upgrade hint for this database.
     */
    @JsonProperty(value = "properties.upgradeHint", access = JsonProperty.Access.WRITE_ONLY)
    private UpgradeHint upgradeHint;

    /**
     * The schemas from this database.
     */
    @JsonProperty(value = "properties.schemas", access = JsonProperty.Access.WRITE_ONLY)
    private List<SchemaInner> schemas;

    /**
     * The transparent data encryption info for this database.
     */
    @JsonProperty(value = "properties.transparentDataEncryption", access = JsonProperty.Access.WRITE_ONLY)
    private List<TransparentDataEncryptionInner> transparentDataEncryption;

    /**
     * The recommended indices for this database.
     */
    @JsonProperty(value = "properties.recommendedIndex", access = JsonProperty.Access.WRITE_ONLY)
    private List<RecommendedIndexInner> recommendedIndex;

    /**
     * Get the collation value.
     *
     * @return the collation value
     */
    public String collation() {
        return this.collation;
    }

    /**
     * Set the collation value.
     *
     * @param collation the collation value to set
     * @return the DatabaseInner object itself.
     */
    public DatabaseInner withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    /**
     * Get the creationDate value.
     *
     * @return the creationDate value
     */
    public DateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the containmentState value.
     *
     * @return the containmentState value
     */
    public Long containmentState() {
        return this.containmentState;
    }

    /**
     * Get the currentServiceObjectiveId value.
     *
     * @return the currentServiceObjectiveId value
     */
    public UUID currentServiceObjectiveId() {
        return this.currentServiceObjectiveId;
    }

    /**
     * Get the databaseId value.
     *
     * @return the databaseId value
     */
    public String databaseId() {
        return this.databaseId;
    }

    /**
     * Get the earliestRestoreDate value.
     *
     * @return the earliestRestoreDate value
     */
    public DateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    /**
     * Get the createMode value.
     *
     * @return the createMode value
     */
    public CreateMode createMode() {
        return this.createMode;
    }

    /**
     * Set the createMode value.
     *
     * @param createMode the createMode value to set
     * @return the DatabaseInner object itself.
     */
    public DatabaseInner withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    /**
     * Get the sourceDatabaseId value.
     *
     * @return the sourceDatabaseId value
     */
    public String sourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    /**
     * Set the sourceDatabaseId value.
     *
     * @param sourceDatabaseId the sourceDatabaseId value to set
     * @return the DatabaseInner object itself.
     */
    public DatabaseInner withSourceDatabaseId(String sourceDatabaseId) {
        this.sourceDatabaseId = sourceDatabaseId;
        return this;
    }

    /**
     * Get the edition value.
     *
     * @return the edition value
     */
    public DatabaseEditions edition() {
        return this.edition;
    }

    /**
     * Set the edition value.
     *
     * @param edition the edition value to set
     * @return the DatabaseInner object itself.
     */
    public DatabaseInner withEdition(DatabaseEditions edition) {
        this.edition = edition;
        return this;
    }

    /**
     * Get the maxSizeBytes value.
     *
     * @return the maxSizeBytes value
     */
    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    /**
     * Set the maxSizeBytes value.
     *
     * @param maxSizeBytes the maxSizeBytes value to set
     * @return the DatabaseInner object itself.
     */
    public DatabaseInner withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    /**
     * Get the requestedServiceObjectiveId value.
     *
     * @return the requestedServiceObjectiveId value
     */
    public UUID requestedServiceObjectiveId() {
        return this.requestedServiceObjectiveId;
    }

    /**
     * Set the requestedServiceObjectiveId value.
     *
     * @param requestedServiceObjectiveId the requestedServiceObjectiveId value to set
     * @return the DatabaseInner object itself.
     */
    public DatabaseInner withRequestedServiceObjectiveId(UUID requestedServiceObjectiveId) {
        this.requestedServiceObjectiveId = requestedServiceObjectiveId;
        return this;
    }

    /**
     * Get the requestedServiceObjectiveName value.
     *
     * @return the requestedServiceObjectiveName value
     */
    public ServiceObjectiveName requestedServiceObjectiveName() {
        return this.requestedServiceObjectiveName;
    }

    /**
     * Set the requestedServiceObjectiveName value.
     *
     * @param requestedServiceObjectiveName the requestedServiceObjectiveName value to set
     * @return the DatabaseInner object itself.
     */
    public DatabaseInner withRequestedServiceObjectiveName(ServiceObjectiveName requestedServiceObjectiveName) {
        this.requestedServiceObjectiveName = requestedServiceObjectiveName;
        return this;
    }

    /**
     * Get the serviceLevelObjective value.
     *
     * @return the serviceLevelObjective value
     */
    public ServiceObjectiveName serviceLevelObjective() {
        return this.serviceLevelObjective;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public String status() {
        return this.status;
    }

    /**
     * Get the elasticPoolName value.
     *
     * @return the elasticPoolName value
     */
    public String elasticPoolName() {
        return this.elasticPoolName;
    }

    /**
     * Set the elasticPoolName value.
     *
     * @param elasticPoolName the elasticPoolName value to set
     * @return the DatabaseInner object itself.
     */
    public DatabaseInner withElasticPoolName(String elasticPoolName) {
        this.elasticPoolName = elasticPoolName;
        return this;
    }

    /**
     * Get the defaultSecondaryLocation value.
     *
     * @return the defaultSecondaryLocation value
     */
    public String defaultSecondaryLocation() {
        return this.defaultSecondaryLocation;
    }

    /**
     * Get the serviceTierAdvisors value.
     *
     * @return the serviceTierAdvisors value
     */
    public List<ServiceTierAdvisorInner> serviceTierAdvisors() {
        return this.serviceTierAdvisors;
    }

    /**
     * Get the upgradeHint value.
     *
     * @return the upgradeHint value
     */
    public UpgradeHint upgradeHint() {
        return this.upgradeHint;
    }

    /**
     * Get the schemas value.
     *
     * @return the schemas value
     */
    public List<SchemaInner> schemas() {
        return this.schemas;
    }

    /**
     * Get the transparentDataEncryption value.
     *
     * @return the transparentDataEncryption value
     */
    public List<TransparentDataEncryptionInner> transparentDataEncryption() {
        return this.transparentDataEncryption;
    }

    /**
     * Get the recommendedIndex value.
     *
     * @return the recommendedIndex value
     */
    public List<RecommendedIndexInner> recommendedIndex() {
        return this.recommendedIndex;
    }

}
