/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for TransparentDataEncryptionActivityStates.
 */
public final class TransparentDataEncryptionActivityStates {
    /** Static value Encrypting for TransparentDataEncryptionActivityStates. */
    public static final TransparentDataEncryptionActivityStates ENCRYPTING = new TransparentDataEncryptionActivityStates("Encrypting");

    /** Static value Decrypting for TransparentDataEncryptionActivityStates. */
    public static final TransparentDataEncryptionActivityStates DECRYPTING = new TransparentDataEncryptionActivityStates("Decrypting");

    private String value;

    /**
     * Creates a custom value for TransparentDataEncryptionActivityStates.
     * @param value the custom value
     */
    public TransparentDataEncryptionActivityStates(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TransparentDataEncryptionActivityStates)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TransparentDataEncryptionActivityStates rhs = (TransparentDataEncryptionActivityStates) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
