/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for TargetDatabaseEditions.
 */
public final class TargetDatabaseEditions {
    /** Static value Basic for TargetDatabaseEditions. */
    public static final TargetDatabaseEditions BASIC = new TargetDatabaseEditions("Basic");

    /** Static value Standard for TargetDatabaseEditions. */
    public static final TargetDatabaseEditions STANDARD = new TargetDatabaseEditions("Standard");

    /** Static value Premium for TargetDatabaseEditions. */
    public static final TargetDatabaseEditions PREMIUM = new TargetDatabaseEditions("Premium");

    /** Static value Free for TargetDatabaseEditions. */
    public static final TargetDatabaseEditions FREE = new TargetDatabaseEditions("Free");

    /** Static value Stretch for TargetDatabaseEditions. */
    public static final TargetDatabaseEditions STRETCH = new TargetDatabaseEditions("Stretch");

    /** Static value DataWarehouse for TargetDatabaseEditions. */
    public static final TargetDatabaseEditions DATA_WAREHOUSE = new TargetDatabaseEditions("DataWarehouse");

    private String value;

    /**
     * Creates a custom value for TargetDatabaseEditions.
     * @param value the custom value
     */
    public TargetDatabaseEditions(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TargetDatabaseEditions)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TargetDatabaseEditions rhs = (TargetDatabaseEditions) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
