/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for DatabaseEditions.
 */
public final class DatabaseEditions {
    /** Static value Web for DatabaseEditions. */
    public static final DatabaseEditions WEB = new DatabaseEditions("Web");

    /** Static value Business for DatabaseEditions. */
    public static final DatabaseEditions BUSINESS = new DatabaseEditions("Business");

    /** Static value Basic for DatabaseEditions. */
    public static final DatabaseEditions BASIC = new DatabaseEditions("Basic");

    /** Static value Standard for DatabaseEditions. */
    public static final DatabaseEditions STANDARD = new DatabaseEditions("Standard");

    /** Static value Premium for DatabaseEditions. */
    public static final DatabaseEditions PREMIUM = new DatabaseEditions("Premium");

    /** Static value Free for DatabaseEditions. */
    public static final DatabaseEditions FREE = new DatabaseEditions("Free");

    /** Static value Stretch for DatabaseEditions. */
    public static final DatabaseEditions STRETCH = new DatabaseEditions("Stretch");

    /** Static value DataWarehouse for DatabaseEditions. */
    public static final DatabaseEditions DATA_WAREHOUSE = new DatabaseEditions("DataWarehouse");

    private String value;

    /**
     * Creates a custom value for DatabaseEditions.
     * @param value the custom value
     */
    public DatabaseEditions(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DatabaseEditions)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DatabaseEditions rhs = (DatabaseEditions) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
