/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.sql.ElasticPoolActivity;
import com.microsoft.azure.management.sql.ElasticPoolDatabaseActivity;
import com.microsoft.azure.management.sql.ElasticPoolEditions;
import com.microsoft.azure.management.sql.ElasticPoolState;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlDatabaseMetric;
import com.microsoft.azure.management.sql.SqlDatabaseMetricDefinition;
import com.microsoft.azure.management.sql.SqlDatabaseOperations;
import com.microsoft.azure.management.sql.SqlDatabaseStandardServiceObjective;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlElasticPoolBasicEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolBasicMaxEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolBasicMinEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolOperations;
import com.microsoft.azure.management.sql.SqlElasticPoolPremiumEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolPremiumMaxEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolPremiumMinEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolPremiumSorage;
import com.microsoft.azure.management.sql.SqlElasticPoolStandardEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolStandardMaxEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolStandardMinEDTUs;
import com.microsoft.azure.management.sql.SqlElasticPoolStandardStorage;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.ElasticPoolActivityImpl;
import com.microsoft.azure.management.sql.implementation.ElasticPoolActivityInner;
import com.microsoft.azure.management.sql.implementation.ElasticPoolDatabaseActivityImpl;
import com.microsoft.azure.management.sql.implementation.ElasticPoolDatabaseActivityInner;
import com.microsoft.azure.management.sql.implementation.ElasticPoolInner;
import com.microsoft.azure.management.sql.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.sql.implementation.MetricInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseForElasticPoolImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseMetricDefinitionImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseMetricImpl;
import com.microsoft.azure.management.sql.implementation.SqlDatabasesAsExternalChildResourcesImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlElasticPoolImpl
extends ExternalChildResourceImpl<SqlElasticPool, ElasticPoolInner, SqlServerImpl, SqlServer>
implements SqlElasticPool,
SqlElasticPool.SqlElasticPoolDefinition<SqlServer.DefinitionStages.WithCreate>,
SqlElasticPoolOperations.DefinitionStages.WithCreate,
SqlElasticPool.Update,
SqlElasticPoolOperations.SqlElasticPoolOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlServerLocation;
    private SqlDatabasesAsExternalChildResourcesImpl sqlDatabases;

    SqlElasticPoolImpl(String name, SqlServerImpl parent, ElasticPoolInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        this.sqlServerLocation = parent.regionName();
        this.sqlDatabases = null;
    }

    SqlElasticPoolImpl(String resourceGroupName, String sqlServerName, String sqlServerLocation, String name, ElasticPoolInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
    }

    SqlElasticPoolImpl(String name, ElasticPoolInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
    }

    public String id() {
        return ((ElasticPoolInner)((Object)this.inner())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public DateTime creationDate() {
        return ((ElasticPoolInner)((Object)this.inner())).creationDate();
    }

    @Override
    public ElasticPoolState state() {
        return ((ElasticPoolInner)((Object)this.inner())).state();
    }

    @Override
    public ElasticPoolEditions edition() {
        return ((ElasticPoolInner)((Object)this.inner())).edition();
    }

    @Override
    public int dtu() {
        return ((ElasticPoolInner)((Object)this.inner())).dtu();
    }

    @Override
    public int databaseDtuMax() {
        return ((ElasticPoolInner)((Object)this.inner())).databaseDtuMax();
    }

    @Override
    public int databaseDtuMin() {
        return ((ElasticPoolInner)((Object)this.inner())).databaseDtuMin();
    }

    @Override
    public int storageMB() {
        return ((ElasticPoolInner)((Object)this.inner())).storageMB();
    }

    @Override
    public int storageCapacityInMB() {
        return ((ElasticPoolInner)((Object)this.inner())).storageMB();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    @Override
    public String regionName() {
        return this.sqlServerLocation;
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public List<ElasticPoolActivity> listActivities() {
        ArrayList<ElasticPoolActivityImpl> elasticPoolActivities = new ArrayList<ElasticPoolActivityImpl>();
        List<ElasticPoolActivityInner> elasticPoolActivityInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPoolActivities().listByElasticPool(this.resourceGroupName, this.sqlServerName, this.name());
        if (elasticPoolActivityInners != null) {
            for (ElasticPoolActivityInner inner : elasticPoolActivityInners) {
                elasticPoolActivities.add(new ElasticPoolActivityImpl(inner));
            }
        }
        return Collections.unmodifiableList(elasticPoolActivities);
    }

    @Override
    public Observable<ElasticPoolActivity> listActivitiesAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPoolActivities().listByElasticPoolAsync(this.resourceGroupName, this.sqlServerName, this.name()).flatMap((Func1)new Func1<List<ElasticPoolActivityInner>, Observable<ElasticPoolActivityInner>>(){

            public Observable<ElasticPoolActivityInner> call(List<ElasticPoolActivityInner> elasticPoolActivityInners) {
                return Observable.from(elasticPoolActivityInners);
            }
        }).map((Func1)new Func1<ElasticPoolActivityInner, ElasticPoolActivity>(){

            public ElasticPoolActivity call(ElasticPoolActivityInner elasticPoolActivityInner) {
                return new ElasticPoolActivityImpl(elasticPoolActivityInner);
            }
        });
    }

    @Override
    public List<ElasticPoolDatabaseActivity> listDatabaseActivities() {
        ArrayList<ElasticPoolDatabaseActivityImpl> elasticPoolDatabaseActivities = new ArrayList<ElasticPoolDatabaseActivityImpl>();
        List<ElasticPoolDatabaseActivityInner> elasticPoolDatabaseActivityInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPoolDatabaseActivities().listByElasticPool(this.resourceGroupName, this.sqlServerName, this.name());
        if (elasticPoolDatabaseActivityInners != null) {
            for (ElasticPoolDatabaseActivityInner inner : elasticPoolDatabaseActivityInners) {
                elasticPoolDatabaseActivities.add(new ElasticPoolDatabaseActivityImpl(inner));
            }
        }
        return Collections.unmodifiableList(elasticPoolDatabaseActivities);
    }

    @Override
    public Observable<ElasticPoolDatabaseActivity> listDatabaseActivitiesAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPoolDatabaseActivities().listByElasticPoolAsync(this.resourceGroupName, this.sqlServerName, this.name()).flatMap((Func1)new Func1<List<ElasticPoolDatabaseActivityInner>, Observable<ElasticPoolDatabaseActivityInner>>(){

            public Observable<ElasticPoolDatabaseActivityInner> call(List<ElasticPoolDatabaseActivityInner> elasticPoolDatabaseActivityInners) {
                return Observable.from(elasticPoolDatabaseActivityInners);
            }
        }).map((Func1)new Func1<ElasticPoolDatabaseActivityInner, ElasticPoolDatabaseActivity>(){

            public ElasticPoolDatabaseActivity call(ElasticPoolDatabaseActivityInner elasticPoolDatabaseActivityInner) {
                return new ElasticPoolDatabaseActivityImpl(elasticPoolDatabaseActivityInner);
            }
        });
    }

    @Override
    public List<SqlDatabaseMetric> listDatabaseMetrics(String filter) {
        ArrayList<SqlDatabaseMetricImpl> databaseMetrics = new ArrayList<SqlDatabaseMetricImpl>();
        List<MetricInner> inners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().listMetrics(this.resourceGroupName, this.sqlServerName, this.name(), filter);
        if (inners != null) {
            for (MetricInner inner : inners) {
                databaseMetrics.add(new SqlDatabaseMetricImpl(inner));
            }
        }
        return Collections.unmodifiableList(databaseMetrics);
    }

    @Override
    public Observable<SqlDatabaseMetric> listDatabaseMetricsAsync(String filter) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().listMetricsAsync(this.resourceGroupName, this.sqlServerName, this.name(), filter).flatMap((Func1)new Func1<List<MetricInner>, Observable<MetricInner>>(){

            public Observable<MetricInner> call(List<MetricInner> metricInners) {
                return Observable.from(metricInners);
            }
        }).map((Func1)new Func1<MetricInner, SqlDatabaseMetric>(){

            public SqlDatabaseMetric call(MetricInner metricInner) {
                return new SqlDatabaseMetricImpl(metricInner);
            }
        });
    }

    @Override
    public List<SqlDatabaseMetricDefinition> listDatabaseMetricDefinitions() {
        ArrayList<SqlDatabaseMetricDefinitionImpl> databaseMetricDefinitions = new ArrayList<SqlDatabaseMetricDefinitionImpl>();
        List<MetricDefinitionInner> inners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().listMetricDefinitions(this.resourceGroupName, this.sqlServerName, this.name());
        if (inners != null) {
            for (MetricDefinitionInner inner : inners) {
                databaseMetricDefinitions.add(new SqlDatabaseMetricDefinitionImpl(inner));
            }
        }
        return Collections.unmodifiableList(databaseMetricDefinitions);
    }

    @Override
    public Observable<SqlDatabaseMetricDefinition> listDatabaseMetricDefinitionsAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().listMetricDefinitionsAsync(this.resourceGroupName, this.sqlServerName, this.name()).flatMap((Func1)new Func1<List<MetricDefinitionInner>, Observable<MetricDefinitionInner>>(){

            public Observable<MetricDefinitionInner> call(List<MetricDefinitionInner> metricDefinitionInners) {
                return Observable.from(metricDefinitionInners);
            }
        }).map((Func1)new Func1<MetricDefinitionInner, SqlDatabaseMetricDefinition>(){

            public SqlDatabaseMetricDefinition call(MetricDefinitionInner metricDefinitionInner) {
                return new SqlDatabaseMetricDefinitionImpl(metricDefinitionInner);
            }
        });
    }

    @Override
    public List<SqlDatabase> listDatabases() {
        ArrayList<SqlDatabaseImpl> databases = new ArrayList<SqlDatabaseImpl>();
        List<DatabaseInner> databaseInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().listByElasticPool(this.resourceGroupName, this.sqlServerName, this.name());
        if (databaseInners != null) {
            for (DatabaseInner inner : databaseInners) {
                databases.add(new SqlDatabaseImpl(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation, inner.name(), inner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(databases);
    }

    @Override
    public Observable<SqlDatabase> listDatabasesAsync() {
        final SqlElasticPoolImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().listByElasticPoolAsync(self.resourceGroupName, self.sqlServerName, this.name()).flatMap((Func1)new Func1<List<DatabaseInner>, Observable<DatabaseInner>>(){

            public Observable<DatabaseInner> call(List<DatabaseInner> databaseInners) {
                return Observable.from(databaseInners);
            }
        }).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner databaseInner) {
                return new SqlDatabaseImpl(self.resourceGroupName, self.sqlServerName, self.sqlServerLocation, databaseInner.name(), databaseInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public SqlDatabase getDatabase(String databaseName) {
        DatabaseInner databaseInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).databases().get(this.resourceGroupName, this.sqlServerName, databaseName);
        return databaseInner != null ? new SqlDatabaseImpl(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation, databaseName, databaseInner, this.sqlServerManager) : null;
    }

    @Override
    public SqlDatabase addNewDatabase(String databaseName) {
        return (SqlDatabase)((SqlDatabaseOperations.DefinitionStages.WithSqlServer)this.sqlServerManager.sqlServers().databases().define(databaseName)).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation).withExistingElasticPool(this).create();
    }

    @Override
    public SqlDatabase addExistingDatabase(String databaseName) {
        return (SqlDatabase)((SqlDatabase.Update)this.getDatabase(databaseName).update()).withExistingElasticPool(this).apply();
    }

    @Override
    public SqlDatabase addExistingDatabase(SqlDatabase database) {
        return (SqlDatabase)((SqlDatabase.Update)database.update()).withExistingElasticPool(this).apply();
    }

    @Override
    public SqlDatabase removeDatabase(String databaseName) {
        return (SqlDatabase)((SqlDatabase.Update)this.getDatabase(databaseName).update()).withoutElasticPool().withStandardEdition(SqlDatabaseStandardServiceObjective.S0).apply();
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Completable deleteAsync() {
        return this.deleteResourceAsync().toCompletable();
    }

    protected Observable<ElasticPoolInner> getInnerAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public Observable<SqlElasticPool> createResourceAsync() {
        final SqlElasticPoolImpl self = this;
        ((ElasticPoolInner)((Object)this.inner())).withLocation(this.sqlServerLocation);
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (ElasticPoolInner)((Object)this.inner())).map((Func1)new Func1<ElasticPoolInner, SqlElasticPool>(){

            public SqlElasticPool call(ElasticPoolInner inner) {
                self.setInner((Object)inner);
                return self;
            }
        });
    }

    public Observable<SqlElasticPool> updateResourceAsync() {
        final SqlElasticPoolImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (ElasticPoolInner)((Object)this.inner())).map((Func1)new Func1<ElasticPoolInner, SqlElasticPool>(){

            public SqlElasticPool call(ElasticPoolInner inner) {
                self.setInner((Object)inner);
                return self;
            }
        });
    }

    void addParentDependency(TaskGroup.HasTaskGroup parentDependency) {
        this.addDependency(parentDependency);
    }

    public void beforeGroupCreateOrUpdate() {
    }

    public Completable afterPostRunAsync(boolean isGroupFaulted) {
        if (this.sqlDatabases != null) {
            this.sqlDatabases.clear();
        }
        return Completable.complete();
    }

    public Observable<Void> deleteResourceAsync() {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).elasticPools().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public SqlElasticPool.Update update() {
        super.prepareUpdate();
        return this;
    }

    @Override
    public SqlElasticPoolImpl withExistingSqlServer(String resourceGroupName, String sqlServerName, String location) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = location;
        return this;
    }

    @Override
    public SqlElasticPoolImpl withExistingSqlServer(SqlServer sqlServer) {
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        this.sqlServerLocation = sqlServer.regionName();
        return this;
    }

    @Override
    public SqlElasticPoolImpl withEdition(ElasticPoolEditions edition) {
        ((ElasticPoolInner)((Object)this.inner())).withEdition(edition);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withBasicPool() {
        ((ElasticPoolInner)((Object)this.inner())).withEdition(ElasticPoolEditions.BASIC);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withStandardPool() {
        ((ElasticPoolInner)((Object)this.inner())).withEdition(ElasticPoolEditions.STANDARD);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withPremiumPool() {
        ((ElasticPoolInner)((Object)this.inner())).withEdition(ElasticPoolEditions.PREMIUM);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withReservedDtu(SqlElasticPoolBasicEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDtu(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMax(SqlElasticPoolBasicMaxEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMax(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMin(SqlElasticPoolBasicMinEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMin(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withReservedDtu(SqlElasticPoolStandardEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDtu(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMax(SqlElasticPoolStandardMaxEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMax(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMin(SqlElasticPoolStandardMinEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMin(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withStorageCapacity(SqlElasticPoolStandardStorage storageCapacity) {
        ((ElasticPoolInner)((Object)this.inner())).withStorageMB(storageCapacity.capacityInMB());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withReservedDtu(SqlElasticPoolPremiumEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDtu(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMax(SqlElasticPoolPremiumMaxEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMax(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMin(SqlElasticPoolPremiumMinEDTUs eDTU) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMin(eDTU.value());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withStorageCapacity(SqlElasticPoolPremiumSorage storageCapacity) {
        ((ElasticPoolInner)((Object)this.inner())).withStorageMB(storageCapacity.capacityInMB());
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMin(int databaseDtuMin) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMin(databaseDtuMin);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMax(int databaseDtuMax) {
        ((ElasticPoolInner)((Object)this.inner())).withDatabaseDtuMax(databaseDtuMax);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDtu(int dtu) {
        ((ElasticPoolInner)((Object)this.inner())).withDtu(dtu);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withStorageCapacity(int storageMB) {
        ((ElasticPoolInner)((Object)this.inner())).withStorageMB(storageMB);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withNewDatabase(String databaseName) {
        if (this.sqlDatabases == null) {
            this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
        }
        return new SqlDatabaseForElasticPoolImpl(this, this.sqlDatabases.defineInlineDatabase(databaseName).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation)).attach();
    }

    @Override
    public SqlElasticPoolImpl withExistingDatabase(String databaseName) {
        if (this.sqlDatabases == null) {
            this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
        }
        return new SqlDatabaseForElasticPoolImpl(this, this.sqlDatabases.patchUpdateDatabase(databaseName).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation)).attach();
    }

    @Override
    public SqlElasticPoolImpl withExistingDatabase(SqlDatabase database) {
        if (this.sqlDatabases == null) {
            this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
        }
        return new SqlDatabaseForElasticPoolImpl(this, this.sqlDatabases.patchUpdateDatabase(database.name()).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation)).attach();
    }

    public SqlDatabaseForElasticPoolImpl defineDatabase(String databaseName) {
        if (this.sqlDatabases == null) {
            this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
        }
        return new SqlDatabaseForElasticPoolImpl(this, this.sqlDatabases.defineInlineDatabase(databaseName).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation));
    }

    public SqlElasticPoolImpl withTags(Map<String, String> tags) {
        ((ElasticPoolInner)((Object)this.inner())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    public SqlElasticPoolImpl withTag(String key, String value) {
        if (((ElasticPoolInner)((Object)this.inner())).getTags() == null) {
            ((ElasticPoolInner)((Object)this.inner())).withTags(new HashMap());
        }
        ((ElasticPoolInner)((Object)this.inner())).getTags().put(key, value);
        return this;
    }

    public SqlElasticPoolImpl withoutTag(String key) {
        if (((ElasticPoolInner)((Object)this.inner())).getTags() != null) {
            ((ElasticPoolInner)((Object)this.inner())).getTags().remove(key);
        }
        return this;
    }

    public SqlServerImpl attach() {
        return (SqlServerImpl)this.parent();
    }
}

