/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.JobVersionInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobVersionsInner {
    private JobVersionsService service;
    private SqlManagementClientImpl client;

    public JobVersionsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (JobVersionsService)retrofit.create(JobVersionsService.class);
        this.client = client;
    }

    public PagedList<JobVersionInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        ServiceResponse response = (ServiceResponse)this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().single();
        return new PagedList<JobVersionInner>((Page)response.body()){

            public Page<JobVersionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobVersionsInner.this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobVersionInner>> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, ListOperationCallback<JobVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobVersionInner>>>>(){

            public Observable<ServiceResponse<Page<JobVersionInner>>> call(String nextPageLink) {
                return JobVersionsInner.this.listByJobNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobVersionInner>> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.listByJobWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map((Func1)new Func1<ServiceResponse<Page<JobVersionInner>>, Page<JobVersionInner>>(){

            public Page<JobVersionInner> call(ServiceResponse<Page<JobVersionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobVersionInner>>> listByJobWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName).concatMap((Func1)new Func1<ServiceResponse<Page<JobVersionInner>>, Observable<ServiceResponse<Page<JobVersionInner>>>>(){

            public Observable<ServiceResponse<Page<JobVersionInner>>> call(ServiceResponse<Page<JobVersionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobVersionsInner.this.listByJobNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobVersionInner>>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByJob(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobVersionInner>>>>(){

            public Observable<ServiceResponse<Page<JobVersionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobVersionsInner.this.listByJobDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobVersionInner>> listByJobDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobVersionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobVersionInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        return (JobVersionInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion).toBlocking().single()).body();
    }

    public ServiceFuture<JobVersionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, ServiceCallback<JobVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion), serviceCallback);
    }

    public Observable<JobVersionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion).map((Func1)new Func1<ServiceResponse<JobVersionInner>, JobVersionInner>(){

            public JobVersionInner call(ServiceResponse<JobVersionInner> response) {
                return (JobVersionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<JobVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobVersionInner>>>(){

            public Observable<ServiceResponse<JobVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobVersionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobVersionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobVersionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobVersionInner> listByJobNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobVersionInner>((Page)response.body()){

            public Page<JobVersionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobVersionsInner.this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobVersionInner>> listByJobNextAsync(String nextPageLink, ServiceFuture<List<JobVersionInner>> serviceFuture, ListOperationCallback<JobVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobVersionInner>>>>(){

            public Observable<ServiceResponse<Page<JobVersionInner>>> call(String nextPageLink) {
                return JobVersionsInner.this.listByJobNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobVersionInner>> listByJobNextAsync(String nextPageLink) {
        return this.listByJobNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobVersionInner>>, Page<JobVersionInner>>(){

            public Page<JobVersionInner> call(ServiceResponse<Page<JobVersionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobVersionInner>>> listByJobNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByJobNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobVersionInner>>, Observable<ServiceResponse<Page<JobVersionInner>>>>(){

            public Observable<ServiceResponse<Page<JobVersionInner>>> call(ServiceResponse<Page<JobVersionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobVersionsInner.this.listByJobNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobVersionInner>>> listByJobNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByJobNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobVersionInner>>>>(){

            public Observable<ServiceResponse<Page<JobVersionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobVersionsInner.this.listByJobNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobVersionInner>> listByJobNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobVersionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobVersionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobVersions listByJob"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions")
        public Observable<Response<ResponseBody>> listByJob(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobVersions get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions/{jobVersion}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobVersion") int var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobVersions listByJobNext"})
        @GET
        public Observable<Response<ResponseBody>> listByJobNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

