/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerinstance.AzureFileVolume;
import com.microsoft.azure.management.containerinstance.ContainerGroup;
import com.microsoft.azure.management.containerinstance.Volume;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupInner;
import java.util.ArrayList;

@LangDefinition
class VolumeImpl
implements ContainerGroup.DefinitionStages.VolumeDefinitionStages.VolumeDefinition<ContainerGroup.DefinitionStages.WithVolume> {
    private Volume innerVolume;
    private ContainerGroupImpl parent;

    VolumeImpl(ContainerGroupImpl parent, String volumeName) {
        this.parent = parent;
        this.innerVolume = new Volume().withName(volumeName);
    }

    public ContainerGroupImpl attach() {
        if (((ContainerGroupInner)((Object)this.parent.inner())).volumes() == null) {
            ((ContainerGroupInner)((Object)this.parent.inner())).withVolumes(new ArrayList<Volume>());
        }
        ((ContainerGroupInner)((Object)this.parent.inner())).volumes().add(this.innerVolume);
        return this.parent;
    }

    public VolumeImpl withExistingReadWriteAzureFileShare(String shareName) {
        this.ensureAzureFileVolume().withReadOnly(false).withShareName(shareName);
        return this;
    }

    public VolumeImpl withExistingReadOnlyAzureFileShare(String shareName) {
        this.ensureAzureFileVolume().withReadOnly(true).withShareName(shareName);
        return this;
    }

    private AzureFileVolume ensureAzureFileVolume() {
        if (this.innerVolume.azureFile() == null) {
            this.innerVolume.withAzureFile(new AzureFileVolume());
        }
        return this.innerVolume.azureFile();
    }

    public VolumeImpl withStorageAccountName(String storageAccountName) {
        this.ensureAzureFileVolume().withStorageAccountName(storageAccountName);
        return this;
    }

    public VolumeImpl withStorageAccountKey(String storageAccountKey) {
        this.ensureAzureFileVolume().withStorageAccountKey(storageAccountKey);
        return this;
    }
}

