/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerinstance.ContainerGroup;
import com.microsoft.azure.management.containerinstance.ContainerGroups;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupsInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManager;
import com.microsoft.azure.management.containerinstance.implementation.LogsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ContainerGroupsImpl
extends TopLevelModifiableResourcesImpl<ContainerGroup, ContainerGroupImpl, ContainerGroupInner, ContainerGroupsInner, ContainerInstanceManager>
implements ContainerGroups {
    private final StorageManager storageManager;

    protected ContainerGroupsImpl(ContainerInstanceManager manager, StorageManager storageManager) {
        super((InnerSupportsListing)((ContainerInstanceManagementClientImpl)((Object)manager.inner())).containerGroups(), (ManagerBase)manager);
        this.storageManager = storageManager;
    }

    protected ContainerGroupImpl wrapModel(String name) {
        return new ContainerGroupImpl(name, new ContainerGroupInner(), (ContainerInstanceManager)this.manager(), this.storageManager);
    }

    protected ContainerGroupImpl wrapModel(ContainerGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new ContainerGroupImpl(inner.name(), inner, (ContainerInstanceManager)this.manager(), this.storageManager);
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().deleteAsync(resourceGroupName, name).toCompletable();
    }

    public ContainerGroup.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public String getLogContent(String resourceGroupName, String containerName, String containerGroupName) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerLogs().list(resourceGroupName, containerName, containerGroupName).content();
    }

    @Override
    public String getLogContent(String resourceGroupName, String containerName, String containerGroupName, int tailLineCount) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerLogs().list(resourceGroupName, containerName, containerGroupName, tailLineCount).content();
    }

    @Override
    public Observable<String> getLogContentAsync(String resourceGroupName, String containerName, String containerGroupName) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerLogs().listAsync(resourceGroupName, containerName, containerGroupName).map((Func1)new Func1<LogsInner, String>(){

            public String call(LogsInner logsInner) {
                return logsInner.content();
            }
        });
    }

    @Override
    public Observable<String> getLogContentAsync(String resourceGroupName, String containerName, String containerGroupName, int tailLineCount) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerLogs().listAsync(resourceGroupName, containerName, containerGroupName, tailLineCount).map((Func1)new Func1<LogsInner, String>(){

            public String call(LogsInner logsInner) {
                return logsInner.content();
            }
        });
    }
}

