/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 */
package com.microsoft.azure.management.apigeneration;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.CLASS)
public @interface LangDefinition {
    public String ContainerName() default "";
    public boolean IsContainerOnly() default false;
    public String ContainerFileName() default "";
    public boolean CreateAsyncMethods() default false;
    public boolean CreateAsyncMultiThreadMethodParam() default false;
    public boolean DoGeneratorFile() default true;
    public MethodConversion MethodConversionType() default MethodConversion.UnSpecficied;
    
    public enum MethodConversion {
        UnSpecficied,
        Auto,
        OnlyMethod,
    }
}
