/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.correlation;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import com.microsoft.applicationinsights.web.internal.correlation.CorrelationContext;
import com.microsoft.applicationinsights.web.internal.correlation.InstrumentationKeyResolver;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TelemetryCorrelationUtils {
    public static final String CORRELATION_HEADER_NAME = "Request-Id";
    public static final String CORRELATION_CONTEXT_HEADER_NAME = "Correlation-Context";
    public static final String REQUEST_CONTEXT_HEADER_NAME = "Request-Context";
    public static final String REQUEST_CONTEXT_HEADER_APPID_KEY = "appId";
    public static final String REQUEST_CONTEXT_HEADER_ROLENAME_KEY = "roleName";
    public static final int REQUESTID_MAXLENGTH = 1024;

    private TelemetryCorrelationUtils() {
    }

    public static void resolveCorrelation(HttpServletRequest request, HttpServletResponse response, RequestTelemetry requestTelemetry) {
        try {
            if (request == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. request is null.", new Object[0]);
                return;
            }
            if (response == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. response is null.", new Object[0]);
                return;
            }
            if (requestTelemetry == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. requestTelemetry is null.", new Object[0]);
                return;
            }
            String rootId = null;
            String parentId = null;
            String currentId = null;
            String requestId = request.getHeader(CORRELATION_HEADER_NAME);
            if (requestId == null || requestId.isEmpty()) {
                rootId = TelemetryCorrelationUtils.generateRootId();
                currentId = '|' + rootId + '.';
            } else {
                parentId = requestId;
                rootId = TelemetryCorrelationUtils.extractRootId(parentId);
                currentId = TelemetryCorrelationUtils.generateId(parentId);
            }
            requestTelemetry.setId(currentId);
            requestTelemetry.getContext().getOperation().setId(rootId);
            requestTelemetry.getContext().getOperation().setParentId(parentId);
            TelemetryCorrelationUtils.resolveCorrelationContext(request, requestTelemetry);
            TelemetryCorrelationUtils.addTargetAppIdForResponseHeader(response);
        }
        catch (Exception ex) {
            InternalLogger.INSTANCE.error("Failed to resolve correlation. Exception information: %s", ex.toString());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(ex));
        }
    }

    public static String generateChildDependencyId() {
        try {
            RequestTelemetryContext context = ThreadContext.getRequestTelemetryContext();
            if (context == null) {
                InternalLogger.INSTANCE.warn("No Correlation will happen, Thread context is null while generating child dependency", new Object[0]);
                return "";
            }
            RequestTelemetry requestTelemetry = context.getHttpRequestTelemetry();
            String parentId = requestTelemetry.getContext().getOperation().getParentId();
            if (parentId != null && parentId.length() > 0 && !TelemetryCorrelationUtils.isHierarchicalId(parentId)) {
                return requestTelemetry.getContext().getOperation().getParentId();
            }
            return requestTelemetry.getId() + context.incrementChildId() + ".";
        }
        catch (Exception ex) {
            InternalLogger.INSTANCE.error("Failed to generate child ID. Exception information: %s", ex.toString());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(ex));
            return null;
        }
    }

    public static String retrieveCorrelationContext() {
        if (ThreadContext.getRequestTelemetryContext() == null) {
            InternalLogger.INSTANCE.warn("No correlation wil happen, Thread context is null", new Object[0]);
            return "";
        }
        CorrelationContext context = ThreadContext.getRequestTelemetryContext().getCorrelationContext();
        return context.toString();
    }

    public static String retrieveApplicationCorrelationId() {
        String instrumentationKey = TelemetryConfiguration.getActive().getInstrumentationKey();
        String appId = InstrumentationKeyResolver.INSTANCE.resolveInstrumentationKey(instrumentationKey, TelemetryConfiguration.getActive());
        if (appId == null) {
            InternalLogger.INSTANCE.trace("Application correlation Id could not be retrieved (e.g. task may be pending or failed)", new Object[0]);
            return "";
        }
        return "appId=" + appId;
    }

    public static String generateChildDependencyTarget(String requestContext) {
        if (requestContext == null || requestContext.isEmpty()) {
            InternalLogger.INSTANCE.trace("generateChildDependencyTarget: won't continue as requestContext is null or empty.", new Object[0]);
            return "";
        }
        String instrumentationKey = TelemetryConfiguration.getActive().getInstrumentationKey();
        if (instrumentationKey == null || instrumentationKey.isEmpty()) {
            InternalLogger.INSTANCE.error("Failed to generate target correlation. InstrumentationKey is null or empty.", new Object[0]);
            return "";
        }
        String target = TelemetryCorrelationUtils.generateSourceTargetCorrelation(instrumentationKey, requestContext);
        if (target == null) {
            InternalLogger.INSTANCE.warn("Target value is null and hence returning empty string", new Object[0]);
            return "";
        }
        return target;
    }

    public static void resolveRequestSource(HttpServletRequest request, RequestTelemetry requestTelemetry, String instrumentationKey) {
        try {
            if (request == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. request is null.", new Object[0]);
                return;
            }
            if (requestTelemetry == null) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. requestTelemetry is null.", new Object[0]);
                return;
            }
            if (requestTelemetry.getSource() != null) {
                InternalLogger.INSTANCE.trace("Skip resolving request source as it is already initialized.", new Object[0]);
                return;
            }
            String requestContext = request.getHeader(REQUEST_CONTEXT_HEADER_NAME);
            if (requestContext == null || requestContext.isEmpty()) {
                InternalLogger.INSTANCE.info("Skip resolving request source as the following header was not found: %s", REQUEST_CONTEXT_HEADER_NAME);
                return;
            }
            if (instrumentationKey == null || instrumentationKey.isEmpty()) {
                InternalLogger.INSTANCE.error("Failed to resolve correlation. InstrumentationKey is null or empty.", new Object[0]);
                return;
            }
            String source = TelemetryCorrelationUtils.generateSourceTargetCorrelation(instrumentationKey, requestContext);
            requestTelemetry.setSource(source);
        }
        catch (Exception ex) {
            InternalLogger.INSTANCE.error("Failed to resolve request source. Exception information: %s", ex.toString());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(ex));
        }
    }

    public static boolean isHierarchicalId(String id) {
        if (id == null || id.isEmpty()) {
            return false;
        }
        return id.charAt(0) == '|';
    }

    private static void resolveCorrelationContext(HttpServletRequest request, RequestTelemetry requestTelemetry) {
        Enumeration baggages = request.getHeaders(CORRELATION_CONTEXT_HEADER_NAME);
        if (baggages == null) {
            InternalLogger.INSTANCE.warn("Could not access header information: %s", CORRELATION_CONTEXT_HEADER_NAME);
            return;
        }
        if (ThreadContext.getRequestTelemetryContext() == null) {
            InternalLogger.INSTANCE.warn("No correlation will happen Thread context is null while resolving Correlation Context", new Object[0]);
            return;
        }
        CorrelationContext currentCorrelationContext = ThreadContext.getRequestTelemetryContext().getCorrelationContext();
        while (baggages.hasMoreElements()) {
            String baggage = (String)baggages.nextElement();
            currentCorrelationContext.append(baggage);
            Map<String, String> propertyBag = TelemetryCorrelationUtils.getPropertyBag(baggage);
            currentCorrelationContext.getMappings().putAll(propertyBag);
            requestTelemetry.getProperties().putAll(propertyBag);
        }
    }

    private static void addTargetAppIdForResponseHeader(HttpServletResponse response) {
        if (response.containsHeader(REQUEST_CONTEXT_HEADER_NAME)) {
            return;
        }
        String appId = TelemetryCorrelationUtils.retrieveApplicationCorrelationId();
        if (appId == null || appId.isEmpty()) {
            return;
        }
        response.addHeader(REQUEST_CONTEXT_HEADER_NAME, appId);
    }

    private static String generateSourceTargetCorrelation(String instrumentationKey, String requestContext) {
        String appId = TelemetryCorrelationUtils.getKeyValueHeaderValue(requestContext, REQUEST_CONTEXT_HEADER_APPID_KEY);
        String roleName = TelemetryCorrelationUtils.getKeyValueHeaderValue(requestContext, REQUEST_CONTEXT_HEADER_ROLENAME_KEY);
        if (appId == null && roleName == null) {
            return null;
        }
        String myAppId = InstrumentationKeyResolver.INSTANCE.resolveInstrumentationKey(instrumentationKey, TelemetryConfiguration.getActive());
        if (myAppId == null) {
            InternalLogger.INSTANCE.trace("Could not generate source/target correlation as the appId could not be resolved (e.g. task may be pending or failed)", new Object[0]);
            return null;
        }
        String result = null;
        if (appId != null && !appId.equals(myAppId)) {
            result = appId;
        }
        if (roleName != null) {
            result = result != null ? result + " | roleName:" + roleName : "roleName:" + roleName;
        }
        return result;
    }

    private static String getKeyValueHeaderValue(String headerFullValue, String key) {
        return TelemetryCorrelationUtils.getPropertyBag(headerFullValue).get(key);
    }

    private static Map<String, String> getPropertyBag(String baggage) {
        String[] pairs;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String pair : pairs = baggage.split(",")) {
            String[] keyValuePair = pair.trim().split("=");
            if (keyValuePair.length != 2) continue;
            String key = keyValuePair[0].trim();
            String value = keyValuePair[1].trim();
            result.put(key, value);
        }
        return result;
    }

    static String extractRootId(String parentId) {
        int rootEnd = parentId.indexOf(46);
        if (rootEnd < 0) {
            rootEnd = parentId.length();
        }
        int rootStart = parentId.charAt(0) == '|' ? 1 : 0;
        return parentId.substring(rootStart, rootEnd);
    }

    private static String generateRootId() {
        return TelemetryCorrelationUtils.uuidToStringNoDashes(UUID.randomUUID());
    }

    static String uuidToStringNoDashes(UUID guid) {
        long most = guid.getMostSignificantBits();
        long least = guid.getLeastSignificantBits();
        long msb = 0x100000000L;
        long mask = 0xFFFFFFFFL;
        return Long.toHexString(0x100000000L | most >> 32 & 0xFFFFFFFFL).substring(1) + Long.toHexString(0x100000000L | most & 0xFFFFFFFFL).substring(1) + Long.toHexString(0x100000000L | least >> 32 & 0xFFFFFFFFL).substring(1) + Long.toHexString(0x100000000L | least & 0xFFFFFFFFL).substring(1);
    }

    private static String generateId(String parentId) {
        String sanitizedParentId = TelemetryCorrelationUtils.sanitizeParentId(parentId);
        String suffix = TelemetryCorrelationUtils.generateSuffix();
        if (sanitizedParentId.length() + suffix.length() > 1024) {
            return TelemetryCorrelationUtils.shortenId(sanitizedParentId, suffix);
        }
        return sanitizedParentId + suffix + "_";
    }

    private static String shortenId(String parentId, String suffix) {
        int trimPosition;
        for (trimPosition = 1015; trimPosition > 1 && parentId.charAt(trimPosition - 1) != '.' && parentId.charAt(trimPosition - 1) != '_'; --trimPosition) {
        }
        if (trimPosition == 1) {
            return "|" + TelemetryCorrelationUtils.generateRootId() + ".";
        }
        return parentId.substring(0, trimPosition) + suffix + '#';
    }

    private static String sanitizeParentId(String parentId) {
        char lastChar;
        String result = parentId;
        if (!TelemetryCorrelationUtils.isHierarchicalId(parentId)) {
            result = "|" + result;
        }
        if ((lastChar = parentId.charAt(parentId.length() - 1)) != '.' && lastChar != '_') {
            result = result + '.';
        }
        return result;
    }

    private static String generateSuffix() {
        int randomNumber = ThreadLocalRandom.current().nextInt();
        return String.format("%08x", randomNumber);
    }
}

